function check_searchBox() {
	// search department
	$("input#srchPpSect").keyup(function() {
		var passedValue = $("input#srchPpSect").val();
		if(passedValue.val!="") {
			$("div.suggest.one").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchWhouse", { passedValue: passedValue }, function(data) {
				$("div.suggest.one").html(data);
			});
		}
	});
	$("input#srchPpSect").blur(function() {
		if($("#srchPpSect").val()=="") {
			$("div.suggest.one").css("display", "none");
		}
	});
	// search groups
	$("input#srchPpGroup").keyup(function() {
		var passedValue = $("input#srchPpGroup").val();
		if(passedValue.val!="") {
			$("div.suggest.two").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchPpGroup", { passedValue: passedValue }, function(data) {
				$("div.suggest.two").html(data);
			});
		}
	});
	$("input#srchPpGroup").blur(function() {
		if($("#srchPpGroup").val()=="") {
			$("div.suggest.two").css("display", "none");
		}
	});
	// search type
	$("input#srchPpType").keyup(function() {
		var passedValue = $("input#srchPpType").val();
		if(passedValue.val!="") {
			$("div.suggest.three").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchPpType", { passedValue: passedValue }, function(data) {
				$("div.suggest.three").html(data);
			});
		}
	});
	$("input#srchPpType").blur(function() {
		if($("#srchPpType").val()=="") {
			$("div.suggest.three").css("display", "none");
		}
	});
	// search Area
	$("input#srchPpArea").keyup(function() {
		var passedValue = $("input#srchPpArea").val();
		if(passedValue.val!="") {
			$("div.suggest.four").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchPpArea", { passedValue: passedValue }, function(data) {
				$("div.suggest.four").html(data);
			});
		}
	});
	$("input#srchPpArea").blur(function() {
		if($("#srchPpArea").val()=="") {
			$("div.suggest.four").css("display", "none");
		}
	});
	// search amenities
	$("input#srchAmenity").keyup(function() {
		var passedValue = $("input#srchAmenity").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchAmenity", { passedValue: passedValue }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchAmenity").blur(function() {
		if($("#srchAmenity").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search allocation
	$("input#srchAlloc").keyup(function() {
		var passedValue = $("input#srchAlloc").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchAlloc", { passedValue: passedValue }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchAlloc").blur(function() {
		if($("#srchAlloc").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search employee
	$("input#srchEmployee").keyup(function() {
		var passedValue = $("input#srchEmployee").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchEmployee", { passedValue: passedValue }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchEmployee").blur(function() {
		if($("#srchEmployee").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search user
	$("input#srchUser").keyup(function() {
		var passedValue = $("input#srchUser").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchUser", { passedValue: passedValue }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchUser").blur(function() {
		if($("#srchUser").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search default bank account
	$("input#srchDfbank").keyup(function() {
		var passedValue = $("input#srchDfbank").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=srchDfbank", { passedValue: passedValue }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchDfbank").blur(function() {
		if($("#srchDfbank").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
}

/* --------------------------------------------------
-------------------- departments ---------------------
---------------------------------------------------- */
function loadWhouses(pageLimit) {
	$("div.dynamicData.one #loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+15;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allWhouses&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("div.dynamicData.one #loading").css("display", "none");
			$("div.dynamicData.one .load_more_link").addClass('noneLink');
			$("div.dynamicData.one").append(result);
		}
	});
	return false;
}
function check_addWhouse() {
	var whouseName	= $("#whouseName").val();
	var whAddress	= $("#whAddress").val();
	var whPhones	= $("#whPhones").val();
	var whEmail		= $("#whEmail").val();

	if(whouseName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide department name");
		$("#whouseName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(whAddress.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Address is missing");
		$("#whAddress").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(whPhones.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("Phone number is missing");
		$("#whPhones").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(whEmail.length > 0) {
		var emailExp 	= /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/;
		if(!whEmail.match(emailExp)) {
			$("#error4").css("display", "inline");
			$("#error4").html("Invalid email address, try again");
			$("#whEmail").css("border-color", "#FF0000");
			return false;
		} else { clearErrors(); }
	}

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	$.post("./includes/prptyMgt.php?action=saveNew&dest=addWhouse&addedBy="+myUser, { whouseName:whouseName, whAddress:whAddress, whPhones:whPhones, whEmail:whEmail }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new department record successfully.",
				icon: "success",
				timer: 1500,
				button: false
			})
			.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property\
					&action=showDepartInfo&recID="+lastID;
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function check_editWhouse() {
	var whouseID	= $("#whouseID").val();
	var whouseName	= $("#whouseName").val();
	var whAddress	= $("#whAddress").val();
	var whPhones	= $("#whPhones").val();
	var whEmail		= $("#whEmail").val();
	var slcStatus	= $("#slcStatus").val();

	if(whouseName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide department name");
		$("#whouseName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(whAddress.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("Address is missing");
		$("#whAddress").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(whPhones.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Phone number is missing");
		$("#whPhones").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(whEmail.length > 0) {
		var emailExp 	= /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/;
		if(!whEmail.match(emailExp)) {
			$("#error5").css("display", "inline");
			$("#error5").html("Invalid email address, try again");
			$("#whEmail").css("border-color", "#FF0000");
			return false;
		} else { clearErrors(); }
	}

	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

	$.post("./includes/prptyMgt.php?action=updateExist&dest=editWhouse&updatedBy="+myUser, { whouseID:whouseID, whouseName:whouseName ,whAddress:whAddress,whPhones:whPhones,whEmail:whEmail,slcStatus:slcStatus }, function(data) {
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated department record successfully.",
				icon: "success",
				timer: 1500,
				button: false
			})
			.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property\
					&action=showDepartInfo&recID="+whouseID;
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});
	return false;
}
function catchWhouse(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getWhouse", { recID: recID, myUser: myUser, myRole: myRole }, function(data) {
		$("div.twoCols.one header span").html('[1 row]');
		$("div.dynamicData.one").html(data);
	});
	$("div.suggest.one").css("display", "none");
}

/* ------------------------------------------------
-------------------- groups ------------------------
--------------------------------------------------- */
function loadGroups(pageLimit) {
	$("div.dynamicData.two #loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+15;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allGroups&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("div.dynamicData.two #loading").css("display", "none");
			$("div.dynamicData.two .load_more_link").addClass('noneLink');
			$("div.dynamicData.two").append(result);
		}
	});
	return false;
}
function addNewGroup(){
	swal({
		title: "Add Group",
		text: 'Example: Rooms, Halls, Gardens, etc',
		content: "input",
		buttons:["Cancel","Save"]
	})
	.then(groupName=> {
		if (groupName ) {

			$.post("./includes/prptyMgt.php?action=saveNew&dest=addGroup&addedBy="+myUser, { groupName:groupName }, function(data) {
				var addedpos = data.search("added");
				if(addedpos==0) {
					var lastID = data.slice(6,21);
					swal({
						title: "Success!",
						text: "You successfully added new group",
						icon: "success",
							timer: 1500,
							button: false
						})
						.then(value=> {
						window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
					}
					);
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
	return false;
}
function check_editGroup() {
	var groupID 	= $("#groupID").val();
	var txtGroup 	= $("#txtGroup").val();
	var slcStatus 	= $("#slcStatus").val();

	if(txtGroup.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please select bank");
		$("#txtGroup").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

	$.post("./includes/prptyMgt.php?action=updateExist&dest=editGroup&updatedBy="+myUser, { groupID:groupID, txtGroup:txtGroup, slcStatus:slcStatus }, function(data) {
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated group record successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
				}
			);
		} else {
			swal("Oops!", data, "error");

		}
		$("label.process").css("display", "none");
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});
	return false;
}
function catchGroup(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getGroup", { recID: recID, myUser: myUser, myRole: myRole }, function(data) {
		$("div.twoCols.one header span").html('[1 row]');
		$("div.dynamicData.two").html(data);
	});
	$("div.suggest.two").css("display", "none");
}
function delGroup(groupID) {
	swal({
		title: "Are you sure?",
		text: "You going to delete this group!",
		icon: "warning",
		dangerMode:true,
		buttons: ["Cancel","Yes, delete it!"]
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/prptyMgt.php?action=deleteRec&dest=delGroup", { groupID:groupID }, function(data) {
				if(data=="deleted") {
					swal({
						title: "Success!",
						text: "Selected group has been deleted.",
						icon: "success",
							timer: 1500,
							button: false
						})
						.then(value=> {
							window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
						}
					);
				} else {
					swal("Oops", data, "error");
				}
			});
		}
	});
	return false;
}

/* ------------------------------------------------
-------------------- types ------------------------
--------------------------------------------------- */
function loadTypes(pageLimit) {
	$("div.dynamicData.three #loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+15;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allTypes&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("div.dynamicData.three #loading").css("display", "none");
			$("div.dynamicData.three .load_more_link").addClass('noneLink');
			$("div.dynamicData.three").append(result);
		}
	});
	return false;
}
function check_addType() {
	var typeName 	= $("#typeName").val();
	var typePrice 	= $("#typePrice").val();
	var slcGroup 	= $("#slcGroup").val();

	if(typeName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide type label");
		$("#typeName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcGroup.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select group for this type");
		$("#slcGroup").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	$.post("./includes/prptyMgt.php?action=saveNew&dest=addType&addedBy="+myUser, { typeName:typeName, slcGroup:slcGroup, typePrice:typePrice }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new property type successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function check_editType() {
	var typeID 	= $("#typeID").val();
	var typeName 	= $("#typeName").val();
	var typePrice 	= $("#typePrice").val();
	var slcGroup 	= $("#slcGroup").val();

	if(typeName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide type label");
		$("#typeName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcGroup.length < 1 || slcGroup=="--") {
		$("#error2").css("display", "inline");
		$("#error2").html("Select group for this type");
		$("#slcGroup").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	$.post("./includes/prptyMgt.php?action=updateExist&dest=editType&updatedBy="+myUser, { typeID:typeID, typeName:typeName ,slcGroup:slcGroup, typePrice:typePrice}, function(data) {
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated type record successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});

	return false;
}
function catchType(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getType", { recID: recID, myUser: myUser, myRole: myRole }, function(data) {
		$("div.twoCols.one header span").html('[1 row]');
		$("div.dynamicData.three").html(data);
	});
	$("div.suggest.three").css("display", "none");
}
function delType(typeID) {
	swal({
		title: "Are you sure?",
		text: "You going to delete this type!",
		icon: "warning",
		dangerMode:true,
		buttons: ["Cancel","Yes, delete it!"]
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/prptyMgt.php?action=deleteRec&dest=delType", { typeID:typeID }, function(data) {
				if(data=="deleted") {
					swal({
						title: "Success!",
						text: "Selected type has been deleted.",
						icon: "success",
							timer: 1500,
							button: false
						})
						.then(value=> {
							window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
						}
					);
				} else {
					swal("Oops", data, "error");
				}
			});
		}
	});
	return false;
}

/* --------------------------------------------
-------------------- areas -------------------------
--------------------------------------------------- */
function loadAreas(pageLimit) {
	$("div.dynamicData.four #loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+15;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allAreas&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("div.dynamicData.four #loading").css("display", "none");
			$("div.dynamicData.four .load_more_link").addClass('noneLink');
			$("div.dynamicData.four").append(result);
		}
	});
	return false;
}
function addArea(){
	swal({
		title: "Add Area",
		text: 'Give a name to this area',
		content: "input",
		buttons:["Cancel","Save"]
	})
	.then(areaName=> {
		if (areaName) {

			$.post("./includes/prptyMgt.php?action=saveNew&dest=addArea&addedBy="+myUser, { areaName:areaName }, function(data) {
				var addedpos = data.search("added");
				if(addedpos==0) {
					var lastID = data.slice(6,21);
					swal({
						title: "Success!",
						text: "You successfully added new property area.",
						icon: "success",
							timer: 1500,
							button: false
						})
						.then(value=> {
						window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
					}
					);
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
	return false;
}
function check_editArea() {
	var areaID 		= $("#areaID").val();
	var txtArea 	= $("#txtArea").val();
	var slcStatus 	= $("#slcStatus").val();

	if(txtArea.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html(" Please write area name");
		$("#txtArea").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

	$.post("./includes/prptyMgt.php?action=updateExist&dest=editArea&updatedBy="+myUser, { areaID:areaID, txtArea:txtArea, slcStatus:slcStatus }, function(data) {
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated area record successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
				}
			);
		} else {
			swal("Oops!", data, "error");

		}
		$("label.process").css("display", "none");
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});
	return false;
}
function catchArea(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getArea", { recID: recID, myUser: myUser, myRole: myRole }, function(data) {
		$("div.twoCols.four header span").html('[1 row]');
		$("div.dynamicData.four").html(data);
	});
	$("div.suggest.four").css("display", "none");
}
function delArea(areaID) {
	swal({
		title: "Are you sure?",
		text: "You going to delete this area!",
		icon: "warning",
		dangerMode:true,
		buttons: ["Cancel","Yes, delete it!"]
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/prptyMgt.php?action=deleteRec&dest=delArea", { areaID:areaID }, function(data) {
				if(data=="deleted") {
					swal({
						title: "Success!",
						text: "Selected area has been deleted.",
						icon: "success",
							timer: 1500,
							button: false
						})
						.then(value=> {
							window.location = "./workplace.php?role="+myRole+"&task=property&subtask=property";
						}
					);
				} else {
					swal("Oops", data, "error");
				}
			});
		}
	});
	return false;
}

/* ------------------------------------------------
-------------------amenities ----------------------
--------------------------------------------------- */
function updateAmenityBar() {
	var count = $("label#count").html();
	var perPage = $("#slcPerPage").val();
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=setFoundNum&dest=amenity",
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				console.log(result);
				$("#refresh").html('records changed, <a onclick="return loadAmenitiesTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateAmenityBar();
			}, 60000);
		}
	});
}
function loadAmenities(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allAmenity&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadAmenitiesTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allAmenity&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header">\
			<div class="cave button">Action</div>\
                <div class="cave long">Amenity Name</div>\
                <div class="cave lshort">Cost</div>\
                <div class="cave middle">Used For</div>\
				<div class="cave short">Status</div>\
			</div>');
			$("#dataTable").append(result);

			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/prptyMgt.php?action=setFoundNum&dest=amenities",
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function simplyAddAmnty() {
	$("#checkIsFree, #switchUnit").click(function(){
		$('div#switchUnit').toggleClass("switchOn");
		if (document.getElementById("isfree").checked == true) {
			document.getElementById("isfree").checked = false;
		} else {
			document.getElementById("isfree").checked = true;
			$("#cost").val('');
		}
	});
}
function check_addAmnty(){
	var amntyName	= $("#amntyName").val();
	var slcAmnty4 	= $("#slcAmnty4").val();
	var amntyCost  	= $("#cost").val();
	var isfree		= $("input#isfree:checked").val();
	if(isfree!="on") { var isfree="no"; } else { var isfree="yes"; }

	if(amntyName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Amenity name is missing");
		$("#amntyName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcAmnty4.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select property group");
		$("#slcAmnty4").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(isfree=="no" && amntyCost.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("Cost price is missing");
		$("#cost").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

   $.post("./includes/prptyMgt.php?action=saveNew&dest=addAmnty&addedBy="+myUser, { amntyName:amntyName, slcAmnty4:slcAmnty4, amntyCost:amntyCost, isfree:isfree }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new amenity successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=property&subtask=amenities\
					&action=showInfo&recID="+lastID;
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function check_editAmnty(){
	var amntyID		= $("#amntyID").val();
	var amntyName	= $("#amntyName").val();
	var slcAmnty4 	= $("#slcAmnty4").val();
	var amntyCost  	= $("#cost").val();
	var isfree		= $("input#isfree:checked").val();
	if(isfree!="on") { var isfree="no"; } else { var isfree="yes"; }
	var slcStatus  	= $("#slcStatus").val();

	if(amntyName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Amenity name is missing");
		$("#amntyName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcAmnty4.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select property group");
		$("#slcAmnty4").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(isfree=="no" && amntyCost.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("Cost price is missing");
		$("#cost").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

   $.post("./includes/prptyMgt.php?action=updateExist&dest=editAmnty&updatedBy="+myUser, { amntyID:amntyID, amntyName:amntyName, slcAmnty4:slcAmnty4, amntyCost:amntyCost, isfree:isfree, slcStatus:slcStatus }, function(data) {
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated amenity details successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=property&subtask=amenities\
					&action=showInfo&recID="+amntyID;
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function catchAmenity(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getAmenity", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function delAmnty(typeID) {
	swal({
		title: "Are you sure?",
		text: "You going to delete this Amenity!",
		icon: "warning",
		dangerMode:true,
		buttons: ["Cancel","Yes, delete it!"]
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/prptyMgt.php?action=deleteRec&dest=delAmnty", { typeID:typeID }, function(data) {
				if(data=="deleted") {
					swal({
						title: "Success!",
						text: "Selected area has been deleted.",
						icon: "success",
							timer: 1500,
							button: false
						})
						.then(value=> {
							window.location = "./workplace.php?role="+myRole+"&task=property&subtask=amenities";
						}
					);
				} else {
					swal("Oops", data, "error");
				}
			});
		}
	});
	return false;
}

/* ------------------------------------------------
----------------- allocations ----------------------
---------------------------------------------------- */
function updateAllocBar() {
	var count = $("label#count").html();
	var perPage = $("#slcPerPage").val();
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=setFoundNum&dest=allocations",
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, <a onclick="return loadAllocsTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateAllocBar();
			}, 60000);
		}
	});
}
function loadAllocs(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allAllocs&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadAllocsTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allAllocs&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header">\
			<div class="cave button">Action</div>\
                <div class="cave xlmiddle">Property Name</div>\
                <div class="cave middle">Property Type</div>\
                <div class="cave smiddle">Cost</div>\
				<div class="cave lshort">Size</div>\
				<div class="cave lshort">Status</div>\
			</div>');
			$("#dataTable").append(result);

			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/prptyMgt.php?action=setFoundNum&dest=allocations",
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function simplyAddAlloc() {
	$("#slcGroup").change(function() {
		var groupID = $("#slcGroup").val();
		if(groupID=="") {
			$("select#slcType").html('');
		} else {
			$.post("./includes/prptyMgt.php?action=searchRec&dest=getPpTypes", { groupID: groupID }, function(data) {
				$("select#slcType").html(data);
			});
			$.post("./includes/prptyMgt.php?action=searchRec&dest=getPpAmntys", { groupID: groupID }, function(data) {
				$("select#slcAmenities").html(data);
			});
		}
	});
}
function addAmnt4Pprty() {
	var slcAmnty	= $("#slcAmenities").val(); 		var amntyName = $("#slcAmenities :selected").text();

	if(slcAmnty.length < 1 || slcAmnty=="---") {
		$("#error5").css("display", "inline");
		$("#error5").html("Select Amenities");
		$("#slcAmenities").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	var amntyID		= slcAmnty.trim();
	var amntyAdded	= $("input#amntyID", list);

	if((!amntyAdded.is("*") || !amntyAdded.filter(function(i, el){return el.value.indexOf(amntyID) > -1}).is("*"))) {
		$("div.list").append('<div class="listItem num'+num+'">\
			<div class="cave serial"></div>\
			<div class="cave jumbo">\
				<input type="hidden" id="amntyID" name="amntyID[]" value="'+slcAmnty+'" readonly="readonly" />\
				<input type="text" value="'+amntyName+'" readonly="readonly" />\
			</div>\
			<div class="cave medium"><a id="remove" onclick="return removeItem('+num+');">remove</a></div>\
		</div>');
		$("#slcAmenities option:first").attr("selected", "selected");
		num++;
	} else {
        swal("Oops","This amenity already been added to list", "error");
    }
	return false;
}
function check_addAllocation(){
	var shrtName	= $("#shrtName").val();
	var longName  	= $("#longName").val();
	var slcGroup  	= $("#slcGroup").val();
	var slcType		= $("#slcType").val();
	var slcArea		= $("#slcArea").val();

	var price   	= $("#price").val();
	var priceType   = $("#slcPriceType").val();
	var listItem	= $("div.theForm .listItem").height();

	if(shrtName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please type short name");
		$("#shrtName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(longName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please type long name");
		$("#longName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcGroup.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select property group");
		$("#slcGroup").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcType.length < 1 || slcType=="---") {
		$("#error2").css("display", "inline");
		$("#error2").html("Select property type");
		$("#slcType").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcArea.length < 1 || slcArea=="---") {
		$("#error3").css("display", "inline");
		$("#error3").html("Select property location");
		$("#slcArea").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(price.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Property price can't be empty");
		$("#price").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	return true;
}
function catchAlloctn(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getAlloctn", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function addAmnt4PprtyEdit() {
	var allocID		= $("#allocID").val();
	var slcAmnty	= $("#slcAmenities").val();

	if(slcAmnty.length < 1) {
		$("#error5").css("display", "inline");
		$("#error5").html("Select Amenities");
		$("#slcAmenities").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$.post("./includes/prptyMgt.php?action=saveNew&dest=addAmnty4Alloc&addedBy="+myUser, { allocID:allocID, slcAmnty:slcAmnty }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new amenity successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					location.reload();
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
	});
	return false;
}
function delAmnty4Prprty(recNum, recID, allocID) {
	swal({
		title: "Are you sure to delete?",
		text: "You going to remove this amenity from this property.",
		icon: "warning",
		dangerMode:true,
		buttons: ["Cancel","Yes, delete it!"]
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/prptyMgt.php?action=deleteRec&dest=delAmnty4Prprty",{recID:recID,allocID:allocID}, function(data){
				if(data=="deleted") {
					$("div.list div.listItem.num"+recNum).find("input").val("");
					$("div.list div.listItem.num"+recNum).fadeOut(500, function(){ $(this).remove(); });
					swal({
						title: "Success",
						text: "Amenity you selected has been removed permenantly",
						icon: "success",
						timer: 1500,
						button: false
					});
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
	return false;
}
function check_editAllocation(){
	var shrtName	= $("#shrtName").val();
	var longName  	= $("#longName").val();
	var slcGroup  	= $("#slcGroup").val();
	var slcType		= $("#slcType").val();
	var slcArea		= $("#slcArea").val();

	var price   	= $("#price").val();
	var priceType   = $("#slcPriceType").val();

	console.log(price)

	if(shrtName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please type short name");
		$("#shrtName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(longName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please type long name");
		$("#longName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcGroup.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select property group");
		$("#slcGroup").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcType.length < 1 || slcType=="---") {
		$("#error2").css("display", "inline");
		$("#error2").html("Select property type");
		$("#slcType").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcArea.length < 1 || slcArea=="---") {
		$("#error3").css("display", "inline");
		$("#error3").html("Select property location");
		$("#slcArea").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(price.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Property price can't be empty");
		$("#price").css("border-color", "#FF0000");
		return false;
	} /*else if(price < 0.1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Property price can't be empty");
		$("#price").css("border-color", "#FF0000");
		return false;
	}*/ else { clearErrors(); }


	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

	return true;
}

/* ------------------------------------------------
----------------- Employees -----------------------
-------------------------------------------------*/
function updateEmployeeBar() {
	var count = $("label#count").html();
	var perPage = $("#slcPerPage").val();
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=setFoundNum&dest=employees",
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, <a onclick="return loadEmployeesTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateEmployeeBar();
			}, 60000);
		}
	});
}
function loadEmployees(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allEmployees&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadEmployeesTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allEmployees&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header">\
				<div class="cave button">Action</div>\
                <div class="cave lshort">Employee ID</div>\
                <div class="cave long">Employee Name</div>\
                <div class="cave middle">Department</div>\
                <div class="cave middle">Date Joined</div>\
			</div>');
			$("#dataTable").append(result);

			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/prptyMgt.php?action=setFoundNum&dest=employees",
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function addNewEmpRole(){
	swal({
		title: "Add Role",
		text: 'Give a Title to this Role',
		content: "input",
		buttons:["Cancel","Save"]
	})
	.then(roleName=> {
		if (roleName) {
			$.post("./includes/prptyMgt.php?action=saveNew&dest=addEmpRole&addedBy="+myUser, {roleName:roleName}, function(data) {
				var addedpos = data.search("added");
				if(addedpos==0) {
					var lastID = data.slice(6,21);
					swal({
						title: "Success!",
						text: "You successfully added new employee role",
						icon: "success",
						timer: 1500,
						button: false
					});
					$("select#slcRole").append('<option value="'+lastID+'" selected="selected">'+roleName+'</option>');
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
	return false;
}
function check_addEmployee() {
	var empName		= $("#empName").val();
	var slcGender 	= $("#slcGender").val();
	var txtPhone  	= $("#txtPhone").val();
	var txtEmail  	= $("#txtEmail").val();

	var slcDepart  	= $("#slcDepart").val();
	var slcRole  	= $("#slcRole").val();
	var dateJoined  = $("#dateJoined").val();

	var txtSalary  	= $("#txtSalary").val();
	var txtBonus  	= $("#txtBonus").val();
	var txtRef  	= $("#txtRef").val();
	var txtRefPhone	= $("#txtRefPhone").val();

	if(empName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Employee name is missing");
		$("#empName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(txtPhone.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Phone number can't be empty");
		$("#txtPhone").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(txtEmail.length > 0) {
		var emailExp = /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/;
		if(!txtEmail.match(emailExp)) {
			$("#error3").css("display", "inline");
			$("#error3").html("invalid email address");
			$("#txtEmail").css("border-color", "#FF0000");
			return false;
		} else { clearErrors(); }
	}

	if(slcDepart.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Select department "+empName+" will work");
		$("#slcDepart").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcRole.length < 1) {
		$("#error5").css("display", "inline");
		$("#error5").html("Select employee role");
		$("#slcRole").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	$.post("./includes/prptyMgt.php?action=saveNew&dest=addEmployee&addedBy="+myUser, { empName:empName, slcGender:slcGender, txtPhone:txtPhone, txtEmail:txtEmail, slcDepart:slcDepart, slcRole:slcRole, dateJoined:dateJoined, txtSalary:txtSalary, txtBonus:txtBonus, txtRef:txtRef, txtRefPhone:txtRefPhone }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You registered new employee successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=hrm&subtask=employees\
					&action=showInfo&recID="+lastID;
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function check_editEmployee() {
	var empID		= $("#empID").val();
	var histID		= $("#histID").val();
	var empName		= $("#empName").val();
	var slcGender 	= $("#slcGender").val();
	var txtPhone  	= $("#txtPhone").val();
	var txtEmail  	= $("#txtEmail").val();

	var DepartID  	= $("#DepartID").val();
	var slcDepart  	= $("#slcDepart").val();
	var RoleID  	= $("#RoleID").val();
	var slcRole  	= $("#slcRole").val();
	var dateJoined  = $("#dateJoined").val();

	var txtSalary  	= $("#txtSalary").val();
	var txtBonus  	= $("#txtBonus").val();
	var txtRef  	= $("#txtRef").val();
	var txtRefPhone	= $("#txtRefPhone").val();
	var slcStatus	= $("#slcStatus").val();

	if(empName.length < 1 || empID.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Employee name is missing");
		$("#empName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(txtPhone.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Phone number can't be empty");
		$("#txtPhone").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(txtEmail.length > 0) {
		var emailExp = /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/;
		if(!txtEmail.match(emailExp)) {
			$("#error3").css("display", "inline");
			$("#error3").html("invalid email address");
			$("#txtEmail").css("border-color", "#FF0000");
			return false;
		} else { clearErrors(); }
	}

	if(slcDepart.length < 1 || slcDepart=="--") {
		$("#error4").css("display", "inline");
		$("#error4").html("Select department "+empName+" will work");
		$("#slcDepart").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcRole.length < 1 || slcRole=="--") {
		$("#error5").css("display", "inline");
		$("#error5").html("Select employee role");
		$("#slcRole").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

	$.post("./includes/prptyMgt.php?action=updateExist&dest=editEmployee&updatedBy="+myUser, {empID:empID, histID:histID, empName:empName, slcGender:slcGender, txtPhone:txtPhone, txtEmail:txtEmail, DepartID:DepartID, slcDepart:slcDepart, RoleID:RoleID, slcRole:slcRole, dateJoined:dateJoined, txtSalary:txtSalary, txtBonus:txtBonus, txtRef:txtRef, txtRefPhone:txtRefPhone,slcStatus:slcStatus }, function(data) {
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated employee details successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=hrm&subtask=employees\
					&action=showInfo&recID="+empID;
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function catchEmployee(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getEmployee", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}

/* ---------------------------------------------
------------------- Users ----------------------
------------------------------------------------*/
function updateUserBar() {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=setFoundNum&dest=users&myUser="+myUser,
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, <a onclick="return loadUsersTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateUserBar();
			}, 60000);
		}
	});
}
function loadUsers(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allUsers&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadUsersTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allUsers&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header"><div class="cave button">Action</div><div class="cave middle">Username</div><div class="cave long">Full name</div><div class="cave smiddle">Department</div><div class="cave short">Status</div></div>');
			$("#dataTable").append(result);

			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/prptyMgt.php?action=setFoundNum&dest=users&myUser="+myUser,
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function smpfyAddUser() {
	callSumOSelect()
	window.asd = $('.SlectBox').SumoSelect({ });
	$("input#empName").keyup(function() {
		var empName = $("#empName").val();
		if(empName!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/prptyMgt.php?action=searchRec&dest=pick_employee",{ empName:empName }, function(data) {
				$("div.suggest").html(data);
			});
		} else { $("div.suggest").css("display", "none"); }
		clearErrors();
	});
	// if checkAll is changed
	$("span#tickAll").click(function () {
		$('#checkAll').trigger('change')
		if (document.getElementById("checkAll").checked == true) {
			document.getElementById("checkAll").checked = false;
			$("#tickAll").html("Check All");
			$("input.checkOne").removeAttr("checked");
		} else {
			document.getElementById("checkAll").checked = true;
			$("#tickAll").html("Uncheck All");
			$("input.checkOne").attr("checked", "checked");
		}
		$("#error6").css("display", "none");
	});
	//
	/*$("input#checkAll").click(function () {
		if($("#tickAll").html()=="Check All") {
			$("#tickAll").html("Uncheck All");
			$("input.checkOne").attr("checked", "checked");
		} else {
			$("#tickAll").html("Check All");
			$("input.checkOne").removeAttr("checked");
		}
		$("#error6").css("display", "none");
	});*/
	$("input#checkAll").on('change',function () {
		if($(this).is(':checked')) {
			$(".checkOne").each(function(i, el) {
				$(el).attr('checked', false)
				$(el).prop('checked', false)
			})
		} else {
			$(".checkOne").each(function(i, el) {
				$(el).attr('checked', true)
				$(el).prop('checked', true)
			})
		}
	})
	// click one
	$("input.checkOne").click(function () {
		document.getElementById("checkAll").checked = false;
		$("#tickAll").html("Check All");
		$("#error6").css("display", "none");
	});
	// click tick label
	$("label.tickOne").click(function () {
		var checked = $(this).parent("div").find("input[type='checkbox']:checked").length;
		if(checked==0) {
			$(this).parent("div").find("input[type='checkbox']").attr("checked", "checked");
		} else {
			$(this).parent("div").find("input[type='checkbox']").removeAttr("checked");
		}
		document.getElementById("checkAll").checked = false;
		$("#tickAll").html("Check All");
		$("#error6").css("display", "none");
	});

	$('#theRole').on('change', (e) => {
		let role = $(e.target).val()
		// $('#slcUserDisplayScreenRow').hide();
		if(role == 'kds') $('#slcUserDisplayScreenRow').show();
	})
}
function pickEmployee(empID, empName, gender, empRole) {
	$("input#empID").val(empID);
	$("input#empName").val(empName);
	$("div.displayInfo").css("display", "inline");
	$("p#gender").html(gender);
	$("p#empRole").html(empRole);
	$("div.suggest").css("display", "none");
}
function check_addUser() {
	var empName 		= $("#empName").val();
	var empID 			= $("#empID").val();
	var txtUser			= $("#txtUser").val();
	var txtComm 		= $("#txtComm").val();
	var txtPassword		= $("#txtPassword").val();
	var txtRePass 		= $("#txtRePass").val();
	var one_grant		= $("input.checkOne:checked").val();

	let slcUserCanSee 	= $('#slcUserCanSee').val();

	if(empName.length < 1 || empID.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please select employee");
		$("#txtName").css("border-color", "#FF0000");
		$("div.suggest").css("display", "none");
		return false;
	} else { clearErrors(); }

	if(txtUser.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Username is missing");
		$("#txtUser").css("border-color", "#FF0000");
		return false;
	} else if(txtUser.match(spaceExp)||(txtUser[0]===' ')) { // detect if contains or starts with space
		$("#error2").css("display", "inline");
		$("#error2").html("Space is not allowed");
		$("#txtUser").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(txtComm.length > 0) {
		if((Number(txtComm) < 0.1) || (Number(txtComm) > 100)) {
			$("#error3").css("display", "inline");
			$("#error3").html("Invalid commission value");
			$("input#txtComm").css("border", "1px solid #FF0000");
			return false;
		} else { clearErrors(); }
	}

	if(txtPassword.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Please provide password");
		$("#txtPassword").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(txtRePass.length < 1) {
		$("#error5").css("display", "inline");
		$("#error5").html("Please confirm password");
		$("#txtRePass").css("border-color", "#FF0000");
		return false;
	} else if(txtPassword != txtRePass) {
		$("#error5").css("display", "inline");
		$("#error5").html("Password dismatch");
		$("#txtRePass").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(one_grant!="on") {
		$("#error6").css("display", "inline");
		$("#error6").html("Each user must have at least one right to access the system.");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	return true;
}
function check_editUser() {
	var userID 		= $("#userID").val();
	var txtUser		= $("#txtUser").val();
	var txtComm 	= $("#txtComm").val();
	var slcStatus 	= $("#slcStatus").val();

	var one_grant	= $("input.checkOne:checked").val();

	if(txtComm.length > 0) {
		if((Number(txtComm) < 0.1) || (Number(txtComm) > 100)) {
			$("#error1").css("display", "inline");
			$("#error1").html("Invalid commission value");
			$("input#txtComm").css("border", "1px solid #FF0000");
			return false;
		} else { clearErrors(); }
	}

	if(one_grant!="on") {
		$("#error2").css("display", "inline");
		$("#error2").html("Each user must have at least one right to access the system.");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

	return true;
}
function catchUser(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getUser", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
//
function changePassword(userID, username) {
    swal({
        title: "Change password for '"+username+"'",
        text: 'To reset this password, please provide your password.',
        content: "input",
		buttons:["Cancel","Save"]
    })
    .then(myPassword=> {

        if (myPassword) {

	        $.post("./includes/prptyMgt.php?action=searchRec&dest=checkAdminPass", { myPassword:myPassword,myUser:myUser,myRole:myRole }, function(data) {
	            if(data=="success") {
	               //
	                swal({
	                    title: "Create new password for '"+username+"'",
	                    text: 'Enter the new password here to finish',
	                    content: "input",
						buttons:["Cancel","Save"]
	                })
	                .then(newPassword=> {
	                    if (newPassword) {
	                    //
		                      swal({
		                        title: "Confirm the password",
		                        text: 'Please re-enter password',
		                        content: "input",
								buttons:["Cancel","Save"]
		                    })
		                    .then(rePassword=> {
		                        if (rePassword) {

			                        if (rePassword ==newPassword) {
			                        //
				                        $.post("./includes/prptyMgt.php?action=updateExist&dest=resetPassword&updatedBy="+myUser, {userID:userID, newPassword:newPassword,myRole:myRole }, function(data) {

				                            if(data=="updated") {
				                                swal({
				                                    title: "Success!",
				                                    text: "You successfully changed "+username+"'s password.",
				                                   icon: "success",
													timer: 1500,
													button: false
												})
												.then(value=> {
				                                   location.reload();
				                                }
				                                );
				                            } else {
				                                swal("Oops!", data, "error");
				                            }
				                        });
				                    }
				                }
		                    });
		                }
	                });
	               //
	            } else if(data=="danger") {
	                swal("Oops!", "Your password as invalid, Please try again!", "error");
	                return false;
	            } else {
	                swal("Oops!", data, "error");
	            }
	        });
	    }
    });
    return false;
}
/* ---------------------------------------------
------------------- default banks ----------------------
------------------------------------------------*/
function updateDfbankBar() {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=setFoundNum&dest=Dfbank&myUser="+myUser,
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, <a onclick="return loadDfbankTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateDfbankBar();
			}, 60000);
		}
	});
}

function loadDfbank(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allDfbank&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}

function loadDfbankTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/prptyMgt.php?action=loadTable&dest=allDfbank&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header"> <div class="cave button">Action</div><div class="cave middle">Username</div> <div class="cave lmiddle">Bank Details</div><div class="cave middle">Status</div><div class="cave lmiddle">Added By</div></div>');
			$("#dataTable").append(result);

			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/prptyMgt.php?action=setFoundNum&dest=Dfbank&myUser="+myUser,
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}

function check_addDfbank() {
	var slcUsers		= $("#slcUsers").val();
	var slcbanks 		= $("#slcbanks").val();
	var slcQrCodes      = $("#slcQrCodes").val();

  	if(slcUsers.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Select username ");
		$("#slcUsers").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcbanks.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select Account name ");
		$("#slcbanks").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcQrCodes.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("Select Account number ");
		$("#slcQrCodes").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }


 	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	$.post("./includes/prptyMgt.php?action=saveNew&dest=addDfbank&addedBy="+myUser, { slcUsers:slcUsers, slcbanks:slcbanks,slcQrCodes:slcQrCodes}, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You registered new default bank account successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=hrm&subtask=dfBanks";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function check_editDfbank() {
	var defID 		= $("#defID").val();
	var slcUser 	= $("#slcUser").val();
	var slcAccount	= $("#slcAccount").val();
	var slcStatus 	= $("#slcStatus").val();
	var slcQrCodes  = $("#slcQrCodes").val();

  	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

 	$.post("./includes/prptyMgt.php?action=updateExist&dest=editDfbank&updatedBy="+myUser, { defID:defID,slcUser:slcUser, slcAccount:slcAccount, slcStatus:slcStatus, slcQrCodes:slcQrCodes }, function(data) {
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated bank default record successfully.",
				icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=hrm&subtask=dfBanks";
				}
			);
		} else {
			swal("Oops!", data, "error");

		}
		$("label.process").css("display", "none");
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});
	return false;
}
//
function catchDfbank(recID) {
	$.post("./includes/prptyMgt.php?action=get_recInfo&dest=getDfbank", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}