function check_searchBox() {
	// search Inventory order
	$("input#srchInvOrdr").keyup(function() {
		var passedValue = $("input#srchInvOrdr").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchInvOrdr", { passedValue: passedValue, myWhouse: myWhouse, myRole: myRole  }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchInvOrdr").blur(function() {
		if($("#srchInvOrdr").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search MealItem
	$("input#srchMealItem").keyup(function() {
		var passedValue = $("input#srchMealItem").val();
		if(passedValue.val!="") {
			$("div.suggest.one").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchMealItem", { passedValue: passedValue }, function(data) {
				$("div.suggest.one").html(data);
			});
		}
	});
	$("input#srchMealItem").blur(function() {
		if($("#srchMealItem").val()=="") {
			$("div.suggest.one").css("display", "none");
		}
	});
	// search MealPackage
	$("input#srchMealPackage").keyup(function() {
		var passedValue = $("input#srchMealPackage").val();
		if(passedValue.val!="") {
			$("div.suggest.two").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchMealPackage", { passedValue:passedValue }, function(data){
				$("div.suggest.two").html(data);
			});
		}
	});
	$("input#srchMealPackage").blur(function() {
		if($("#srchMealPackage").val()=="") {
			$("div.suggest.two").css("display", "none");
		}
	});
	// search MealOrder
	$("select#slc4MealOrder").change(function() {
		var slc4MealOrder 	= $("select#slc4MealOrder").val();
		if(slc4MealOrder 	== "orderNo") { $("#srchMealOrder").attr("placeholder", "order number"); } 
		else if(slc4MealOrder == "byBook") { $("#srchMealOrder").attr("placeholder", "customer name"); }
		$("input#srchMealOrder").val(''); $("div.suggest").html(''); $("div.suggest").css("display", "none");
	});
	$("input#srchMealOrder").keyup(function() {
		var passedValue	= $("input#srchMealOrder").val();
		var srchType	= $("select#slc4MealOrder").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchMealOrder", { passedValue:passedValue, srchType:srchType }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchMealOrder").blur(function() {
		if($("#srchMealOrder").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search meal order - waiter form
	$("input#srchWMealOrder").keyup(function() {
		var passedValue = $("input#srchWMealOrder").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchWMealOrder", { passedValue: passedValue, myWhouse:myWhouse, myRole:myRole  }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchWMealOrder").blur(function() {
		if($("#srchWMealOrder").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search table  
	$("input#srchTbl").keyup(function() {
		var passedValue = $("input#srchTbl").val();
		if(passedValue.val!="") {
			$("div.suggest.one").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchTbl", { passedValue: passedValue, myRole: myRole  }, function(data) {
				$("div.suggest.one").html(data);
			});
		}
	});
	$("input#srchTbl").blur(function() {
		if($("#srchTbl").val()=="") {
			$("div.suggest.one").css("display", "none");
		}
	});
	// search Table Reserve
	$("input#srchTblRsve").keyup(function() {
		var passedValue = $("input#srchTblRsve").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchTblRsve", {passedValue:passedValue}, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchTblRsve").blur(function() {
		if($("#srchTblRsve").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search receipt
	$("input#srchRecpt").keyup(function() {
		var passedValue = $("input#srchRecpt").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchRecpt", { passedValue: passedValue, myRole: myRole, myWhouse: myWhouse}, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchRecpt").blur(function() {
		if($("#srchRecpt").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
}

/* ---------------------------------------------------------------
------------------------- inventory order ------------------------
----------------------------------------------------------------- */
function catchInvtryOrdr(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getInvtryOrdr", { recID:recID,myUser:myUser,myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function updateInvtyOrdBar() {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	var dataString = 'myRole='+ myRole+'&myWhouse='+ myWhouse;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=setFoundNum&dest=invtryOrdr",
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, \
				<a onclick="return loadInvtryOrdrTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateInvtyOrdBar();
			}, 60000);
		}
	});
}
function loadInvtryOrdr(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&perPage='+perPage+'&myWhouse='+myWhouse;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allInvtryOrdr&myRole="+myRole+"&myUser="+myUser,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadInvtryOrdrTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&perPage='+perPage+'&myWhouse='+myWhouse;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allInvtryOrdr&myRole="+myRole+"&myUser="+myUser,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header">\
				<div class="cave button">Action</div>\
                <div class="cave lshort">Order #</div>\
                <div class="cave xlmiddle">Department</div>\
                <div class="cave middle">Products ordered</div>\
				<div class="cave lshort">Total Cost</div>\
                <div class="cave lshort">Status</div>\
			</div>');
			$("#dataTable").append(result);
			
			(function (){
				//
				var dataString = 'myRole='+myRole+'&myWhouse='+myWhouse;
				$.ajax({
					type: "POST",
					url: "./includes/restaurant.php?action=setFoundNum&dest=invtryOrdr",
					data: dataString,
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function simplifyInvOrdrAdd() {
	$("#txtSrchPrd").keyup(function(){
		var passedVal	= $("#txtSrchPrd").val();
		var byCtgry		= $("input#byCtgry:checked").val();
		if(byCtgry!="on") { byCtgry="off";}
		if(passedVal!="") {
			$("div.suggest.two").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=prdct4InvtryOrdr", { passedVal: passedVal, byCtgry:byCtgry}, function(data) {
				$("div.suggest.two").html(data);
			});
		} else {
			$("div.suggest.two").css("display", "none");
		}
		$("#slcMeasure").html('');
	});
	//
	var after1year	= Number(thisYear)+1;
	var picker	= new Pikaday({
		field: document.getElementById("transDate"),
		firstDay: 6,
		yearRange: [thisYear,after1year],
	});
	//
	$("#txtRemarks").keyup(function(){
		return tweetFeed(this, 500);
	});
}
function catchPrd4InvOrd(prdtID, prdtName, ctgryName, measures) {
	$("#txtSrchPrd").val(ctgryName+", "+prdtName);
	$("#prdID").val(prdtID);
	$("#slcMeasure").html(measures);
	$("div.suggest.two").css("display", "none");
}
function add2List4InvtOrder() {
	var txtSrchPrd	= $("#txtSrchPrd").val();
	var prdID		= $("#prdID").val();
	var prdQnty		= $("#prdQnty").val();
	var msrID		= $("#slcMeasure").val();				var msrID2		= $("#slcMeasure :selected").text();
	
	if(txtSrchPrd.length < 1 || prdID.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select product");
		$("#slcCtgry").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(prdQnty.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity is missing");
		$("#prdQnty").css("border-color", "#FF0000");
		return false;
	} else if(Number(prdQnty) < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity must be greater than 0");
		$("#prdQnty").css("border-color", "#FF0000");
		return false;
	} else if(Number(prdQnty) > balance) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity can't be greater than "+balance);
		$("#prdQnty").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$("div.list").append('<div class="listItem num'+num+'">\
		<div class="cave serial"></div>\
			<div class="cave xlarge"><input type="hidden" name="prdID[]" value="'+prdID+'" />\
			<input type="text" value="'+txtSrchPrd+'" readonly="readonly" /></div>\
		<div class="cave small">\
			<input type="hidden" name="prdQnty[]" value="'+prdQnty+'" readonly="readonly" />\
			<input type="hidden" name="msrID[]" value="'+msrID+'" readonly="readonly" />\
			<input type="text" value="'+prdQnty+' '+msrID2+'" readonly="readonly" /></div>\
		<div class="cave last"><a id="remove" onclick="return removeItem('+num+');">remove</a></div>\
	</div>');
	
	$("#slcMeasure").html('');
	$("#txtSrchPrd, #prdID, #prdQnty").val('');
	
	num++;
	return false;	
}
function check_addInvtOrdr() {
	var listItem = $("div.theForm .listItem").height();
	if(listItem<1) {
		$("#error3").css("display", "inline");
		$("#error3").html("You must add at least one product to the list");
		if(window.innerWidth<=768) { $('html, body').animate({ scrollTop: $(".record.three").offset().top }, 'slow'); }
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	
	return true;
}
function invtryOrdrApprove(orderID, itemID,  prdtID, quantity, msrID,myWhouse){
	swal({
		title: "Are you sure?",
		text: "You going to aprove this iventory order!",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, approve it!',
		closeOnConfirm: false
		
	},
	function() {
		$.post("./includes/restaurant.php?action=updateExist&dest=invtOrderAproval&updatedBy="+myUser,{itemID:itemID, orderID:orderID, prdtID:prdtID, quantity:quantity, msrID:msrID,myWhouse:myWhouse},function(data){
		if(data=="updated") {
			swal({
				title: "Success",
				text: "the product you selected has been approved successfully",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					location.reload();
				}
			);
		} else {
				swal("Oops!", data, "error");
			}
		});
	});
	return false;
}
function add2List4InvtOrderInEdit(){
	var orderID     = $("#orderID").val();
	var txtSrchPrd	= $("#txtSrchPrd").val();
	var prdID		= $("#prdID").val();
	var prdQnty		= $("#prdQnty").val();
	var msrID		= $("#slcMeasure").val();				var msrID2		= $("#slcMeasure :selected").text();
	
	if(txtSrchPrd.length < 1 || prdID.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select product");
		$("#slcCtgry").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(prdQnty.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity is missing");
		$("#prdQnty").css("border-color", "#FF0000");
		return false;
	} else if(Number(prdQnty) < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity must be greater than 0");
		$("#prdQnty").css("border-color", "#FF0000");
		return false;
	} else if(Number(prdQnty) > balance) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity can't be greater than "+balance);
		$("#prdQnty").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$.post("./includes/restaurant.php?action=saveNew&dest=addPrd4InvtOrderInEdit&addedBy="+myUser, { orderID:orderID, prdID:prdID, prdQnty:prdQnty, msrID:msrID}, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new product for this inventory order successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					location.reload();
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
	});
	return false;
}
function check_editInvtOrdr(){
	var orderID	= $("#orderID").val();
    var status	= $("#status").val();
	var listItem	= $("div.theForm .listItem").height();
	if(status=="aproved") {
		swal("Oops!", "This Inventory Order has been Aproved, therefore it can\'t be updated.", "error");
		return false;
	} 
	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");
	
	return true;
}
function delInvtOrderList(recNum, itemID, orderID){
	swal({
		title: "Are you sure to delete?",
		text: "You going to remove this product from this Inventory Order!",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '##6d3179',
		confirmButtonText: 'Yes, remove it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=deleteRec&dest=delInvtOrderItem",{ itemID:itemID, orderID:orderID }, function(data){
			if(data=="deleted") {
				$("div.list div#listItem.num"+recNum).find("input").val("");
				$("div.list div#listItem.num"+recNum).fadeOut(500, function(){ $(this).remove(); });
				swal({
					title: "Success",
					text: "Product you selected has been removed permenantly",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				});
			} else {
				swal("Oops!", data, "error");
			}
		});
	});
	return false;
}

/* --------------------------------------------------------------
---------------------------- meal management --------------------
----------------------------------------------------------------- */

function catchMealItem(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getMealItem", { recID: recID, myUser: myUser, myRole: myRole }, function(data) {
		$("div.twoCols.one header span").html('[1 row]');
		$("div.dynamicData.one").html(data);
	});
	$("div.suggest.one").css("display", "none");
}
function loadMealItems(pageLimit) {
	$("div.dynamicData.one #loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+15;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allMealItems&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("div.dynamicData.one #loading").css("display", "none");
			$("div.dynamicData.one .load_more_link").addClass('noneLink');
			$("div.dynamicData.one").append(result);
		}
	});
	return false;
}
function check_addMealItem() {
	var itemName	= $("#itemName").val();
	var slcPckge	= $("#slcPckge").val();
	var costPrice	= $("#costPrice").val();
	var slcType		= $("#slcType").val();
 
   	if(itemName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide item name");
		$("#itemName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(slcPckge=="---"){
		$("#error2").css("display", "inline");
		$("#error2").html("Please provide package name");
		$("#slcPckge").css("border-color", "#FF0000");
		return false;
	} else {clearErrors();}
 	if(costPrice.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("Item cost is missing");
		$("#costPrice").css("border-color", "#FF0000");
		return false;
	} else if(costPrice <= 0) {
		$("#error3").css("display", "inline");
		$("#error3").html("Invalid item cost, please try it");
		$("#costPrice").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	 if(slcType=="") {
		 $("#error4").css("display", "inline");
		 $("#error4").html("Please select availability time");
		 $("#slcType").css("border-color", "#FF0000");
		 return false;
   	} else {};
	 
	
 	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	
	return true;
}
function smplfyAddMItem(){
	$("#slcType").change(function(){
		var slcType = $("#slcType").val();
		if(slcType!=""){
			var starTime = endTime = "";
			if(slcType=="morning" || slcType=="custom"){
				var starTime = "05:00"; var endTime = "11:59";
			} else if(slcType=="afternoon"){
				var starTime = "12:00"; var endTime = "17:59";
			} else if(slcType=="evening"){
				var starTime = "18:00"; var endTime = "23:59";
			} else if(slcType=="all-times"){
				var starTime = "00:00"; var endTime = "23:59";
			} else if(slcType=="all-day"){
				var starTime = "05:00"; var endTime = "17:59";
			} else if(slcType=="all-night"){
				var starTime = "18:00"; var endTime = "04:59";
			}
		} else {
			var starTime = endTime = "";
		}
		$("#starTime").val(starTime);
		$("#endTime").val(endTime);
	});
	//
	$("#starTime, #endTime").bind("change, keyup", function() {
		$("#slcType option:last").attr("selected", "selected");
	});
}
/*function addNewPackage() {
	swal({
		title: "Add Package",
		text: 'Give a name to this meal package',
		type: "input",
		showCancelButton: true,
		closeOnConfirm: false,
		animation: "slide-from-top",
		inputPlaceholder: "required",
	},
	function(package) {
		if (package === false) return false;
		if (package === "") {
			swal.showInputError("Please write Type name");
			return false
		}
 		$.post("./includes/restaurant.php?action=saveNew&dest=addMealPckge&addedBy="+myUser, {package:package}, function(data){
			var addedpos = data.search("added");
			if(addedpos==0) {
				var lastID = data.slice(6,21);
				swal({
					title: "Success!",
					text: "You successfully added new package.",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=mealMgt";
					}
				);
			} else {
				swal("Oops!", data, "error");
			}
		});
	});
	return false;
}*/
function check_editMealPckge(){
	var pckgeName 		= $("#pckgeName").val();
	
	if(pckgeName .length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please select Type");
		$("#pckgeName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");
 	
	return true;
}
function delMealItem (itemID){
	swal({
		title: "Are you sure?",
		text: "You going to delete this Meal Item!",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, delete it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=deleteRec&dest=delMealItem", { itemID:itemID }, function(data) {
			if(data=="deleted") {
				swal({
					title: "Success!",
					text: "Selected Meal Item has been deleted.",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=mealMgt";
					}
				);
			} else {
				swal("Oops", data, "error");
			}
		});
	});
	return false;
}

/* ----- meal packages -------- */
function catchMealPackage(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getMealPackage", { recID: recID, myUser: myUser, myRole: myRole }, function(data) {
		$("div.twoCols.two header span").html('[1 row]');
		$("div.dynamicData.two").html(data);
	});
	$("div.suggest.two").css("display", "none");
}
function check_addMealpckge(){
	var pckgName	= $("#pckgName").val();
	
   	if(pckgName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide package name");
		$("#pckgName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
 	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	
	return true;
}
function loadMealPckgs(pageLimit) {
	$("div.dynamicData.two #loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+15;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allMealPckgs&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("div.dynamicData.two #loading").css("display", "none");
			$("div.dynamicData.two .load_more_link").addClass('noneLink');
			$("div.dynamicData.two").append(result);
		}
	});
	return false;
}
function simplyAddMPackage() {
	$("select#slcItem").change(function() {
		var slcItem = $("#slcItem").val();
		if(slcItem.length > 0) {
			$.post("./includes/restaurant.php?action=searchRec&dest=getMealCost", { itemID: slcItem }, function(data) {
				$("input#mealCost").val(data);
			});
		} 
	});
}
function addMeal4Package() {
	var slcItem		= $("#slcItem").val(); 		var itemName = $("#slcItem :selected").text(); 
	var mealCost	= $("#mealCost").val();
	
	if(slcItem.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select meal item");
		$("#slcItem").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	var itemID		= slcItem.trim();
	var itemAdded	= $("input#mealID", list);
	
	if((!itemAdded.is("*") || !itemAdded.filter(function(i, el){return el.value.indexOf(itemID) > -1}).is("*"))) {
		$("div.list").append('<div class="listItem num'+num+'">\
			<div class="cave serial"></div>\
			<div class="cave jumbo">\
				<input type="hidden" id="mealID" name="mealID[]" value="'+slcItem+'" readonly="readonly" />\
				<input type="text" value="'+itemName+'" readonly="readonly" />\
			</div>\
			<div class="cave large">\
				<input type="text" name="Cost[]" value="$'+mealCost+'" readonly="readonly" />\
			</div>\
			<div class="cave medium"><a id="remove" onclick="return removeItem('+num+');">remove</a></div>\
		</div>');
		
		$("#slcItem option:first").attr("selected", "selected");
		$("#mealCost").val('')
		num++;
		
	} else {
        swal("Oops","This meal already been added to list", "error");
    }
	return false;
}
function check_addMealPckge(actionType) {
	var pckgeName	= $("#pckgeName").val();
	var listItem	= $("div.theForm .listItem").height();
	
	if(pckgeName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provoide package name");
		$("#pckgeName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); } 
	
	if(listItem<1) {
		$("#error3").css("display", "inline");
		$("#error3").html("You must add at least one meal to this package");
		if(window.innerWidth<=768) { $('html, body').animate({ scrollTop: $(".record.two").offset().top }, 'slow'); }
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	return true;
}
function addNewMeal4PackageInEdit(){
	var packageID	= $("#packageID").val();
	var slcItem		= $("#slcItem").val();
	
	if(slcItem.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select meal item");
		$("#slcItem").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$.post("./includes/restaurant.php?action=saveNew&dest=addNewMeal4Package&addedBy="+myUser, { packageID:packageID, itemID:slcItem }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new meal for this Package record.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					location.reload();
				}
			);
		} else {
			swal("Oops!", data, "error");
			$("#btnAdd2").attr("disabled", false);
		}
	});
	
	return false;
}
function delMealPckge (packageID){
	swal({
		title: "Are you sure?",
		text: "You going to delete this Meal Package!",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, delete it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=deleteRec&dest=delMealPckge", { packageID:packageID }, function(data) {
			if(data=="deleted") {
				swal({
					title: "Success!",
					text: "Selected Meal Package has been deleted.",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=mealMgt";
					}
				);
			} else {
				swal("Oops", data, "error");
			}
		});
	});
	return false;
}
function delMealPckgeList(recNum, recItemID, packageID){
	swal({
		title: "Are you sure to delete?",
		text: "You going to delete this item from Meal Package.",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, delete it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=deleteRec&dest=delMealPckgeItem",{ recItemID:recItemID, packageID:packageID }, function(data){
			if(data=="deleted") {
				$("div.list div#listItem.num"+recNum).find("input").val("");
				$("div.list div#listItem.num"+recNum).fadeOut(500, function(){ $(this).remove(); });
				swal({
					title: "Success",
					text: "Meal item you selected has been removed permenantly",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				});
			} else {
				swal("Oops!", data, "error");
			}
		});
	});
	return false;
}

/* ---------------------------------------------------------------
---------------------------- meal order --------------------------
----------------------------------------------------------------- */
function catchMealOrder(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getMealOrder", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function catchCMealOrder(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getCMealOrder", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function catchWMealOrder(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getWMealOrder", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function updateChashier(period) {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=setFoundNum&dest=cashier&period="+period,
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				console.log(result);
				$("#refresh").html('records changed, \
				<a onclick="return loadCashierTwo(0,'+perPage+',\''+period+'\');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateChashier(period);
			}, 60000);
		}
	});
}
function loadCashier(pageLimit, perPage, period) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&perPage='+perPage+'&period='+period;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allRecpts&myRole="+myRole+"&myUser="+myUser+"&myWhouse="+myWhouse,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadCashierTwo(pageLimit, perPage, period) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&perPage='+perPage+'&period='+period;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allRecpts&myRole="+myRole+"&myUser="+myUser+"&myWhouse="+myWhouse,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header">\
				<div class="cave button">Action</div>\
                <div class="cave middle">Order Details</div>\
                <div class="cave lmiddle">Waiter or Added By</div>\
                <div class="cave short">Four Digit.</div>\
                <div class="cave lshort">Amount</div>\
                <div class="cave lshort">Balance</div>\
                <div class="cave button">Action</div>\
			</div>');
			$("#dataTable").append(result);
			
			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/restaurant.php?action=setFoundNum&dest=cashier&period="+period,
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function catchMealOrder(recID, task) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getMealOrder", { recID:recID,task:task,myUser:myUser,myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function updateMealOrderBar(period) {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=setFoundNum&dest=mealOrdr&period="+period,
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				console.log(result);
				$("#refresh").html('records changed, \
				<a onclick="return loadMealOrderTwo(0,'+perPage+',\''+period+'\');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateMealOrderBar(period);
			}, 60000);
		}
	});
}
function loadMealOrder(pageLimit, perPage, period, task) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&perPage='+perPage+'&period='+period;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allMealOrdr&myRole="+myRole+"&myUser="+myUser+"&task="+task,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadMealOrderTwo(pageLimit, perPage, period, task) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&perPage='+perPage+'&period='+period;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allMealOrdr&myRole="+myRole+"&myUser="+myUser+"&task="+task,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header">\
				<div class="cave button">Action</div>\
                <div class="cave lshort">Order No.</div>\
                <div class="cave xlmiddle">Order Details</div>\
                <div class="cave middle">No. of items ordered</div>\
                <div class="cave lshort">Amount</div>\
                <div class="cave lshort">Status</div>\
			</div>');
			$("#dataTable").append(result);
			
			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/restaurant.php?action=setFoundNum&dest=mealOrdr&period="+period,
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function simplyAddMealOrder() {
	$("div.record.three").css("display", "none");
	$("select#ordrFrom").change(function() {
		var ordrFrom = $("#ordrFrom").val();
		if(ordrFrom=="outside") {
			$("div.record.two").fadeOut(500);
			$("div.record.three").fadeIn(500);
		} else {
			$("div.record.two").fadeIn(500);
			$("div.record.three").fadeOut(500);
		}
	});
	//
	$("select#prpType").change(function() {
		var prpType = $("#prpType").val();
		$.post("./includes/restaurant.php?action=searchRec&dest=getAlloc4Meal", { prpType: prpType }, function(data) {
			$("select#slcAlloc").html(data);
		});
		clearErrors();
	});
	//
	$("#checkAway, #switchAway").click(function(){ 
		$('div#switchAway').toggleClass("switchOn");
		if(document.getElementById("takeAway").checked == true) {
			document.getElementById("takeAway").checked = false;
		} else {
			document.getElementById("takeAway").checked = true;
		}
	});
	//
	$("select#slcMealType").change(function() {
		var mealType = $("#slcMealType").val();
		$.post("./includes/restaurant.php?action=searchRec&dest=srchMeal4Order", { mealType:mealType }, function(data) {
			$("select#slcMealItem").html(data);
		});
		$("input#txtQnty, input#txtCost, input#subTotal, input#total").val('');
		$("#discount").val(0);
		clearErrors();
	});
	//
	$("select#slcMealItem").change(function() {
		var mealItem = $("#slcMealItem").val();
		$.post("./includes/restaurant.php?action=searchRec&dest=srchMealPrice", { mealItem:mealItem }, function(data) {
			$("input#txtCost").val(data);
		});
		$("input#txtQnty, input#subTotal, input#total").val('');
		$("#discount").val(0);
		clearErrors();
	});
	$("input#txtQnty").bind("keyup change", function(e) {
		var quantity	= parseFloat($("#txtQnty").val());
		var costPrice	= parseFloat($("#txtCost").val());
		var discount 	= parseFloat($("#discount").val());
		
		if(quantity > 0 && costPrice > 0) {
			var subTotal = (quantity*costPrice);
			
			if(discount != 0 || discount != "") {
				if(discount>subTotal) {
					$("input#discount").val(0);
				} 
			}
			$("input#subTotal, input#total").val(subTotal);
		} else {
			$("input#subTotal, input#total").val(0);
		}
		clearErrors();
	});
	$("input#discount").bind("keyup change", function(e) {
		var discount = parseFloat($("#discount").val());
		var subTotal = parseFloat($("#subTotal").val());
		
		if($("input#txtQnty").val()!="" && $("input#txtQnty").val()!=0) {
			if(discount != 0 || discount != "") {
				if(discount>subTotal) {
					var total = (subTotal);
					$("input#discount").val(0);
				} else {
					var total = (subTotal-discount);	
				}
				$("input#total").val(total);
			} else {
				$("input#total").val(subTotal);
			}
		} else {
			$("input#discount").val('');
			$("input#txtQnty").focus();
		}
		clearErrors();
	});
}
function add2List4MOrder() {
	var mealType	= $("#slcMealType").val();			var mealType2	= $("#slcMealType :selected").text();
	var mealID		= $("#slcMealItem").val();			var mealID2		= $("#slcMealItem :selected").text();
	var txtQnty		= $("#txtQnty").val();
	var txtCost		= $("#txtCost").val();
	var subTotal	= Number(txtQnty*txtCost);
	var discount	= $("#discount").val();
	var total		= Number(subTotal-discount);
	
	if(mealType == "---") {
		$("#error4").css("display", "inline");
		$("#error4").html("Select meal package");
		$("#slcMealType").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(mealID == "---") {
		$("#error4").css("display", "inline");
		$("#error4").html("Select meal to add this order");
		$("#slcMealItem").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(txtQnty.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Quantity is missing");
		$("#txtQnty").css("border-color", "#FF0000");
		return false;
	} else if(Number(txtQnty) < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Quantity must be greater than 0");
		$("#txtQnty").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(txtCost.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Price can't be empty");
		$("#txtCost").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$("div.list").append('<div class="listItem num'+num+'">\
		<div class="cave serial"></div>\
		<div class="cave large">\
			<input type="hidden" name="mealType[]" value="'+mealType+'" readonly="readonly" />\
			<input type="hidden" id="mealID" name="mealID[]" value="'+mealID+'" readonly="readonly" />\
			<input type="text" value="'+mealType2+', '+mealID2+'" readonly="readonly" />\
		</div>\
		<div class="cave vsmall">\
			<input type="text" name="mealQnty[]" value="'+txtQnty+'" readonly="readonly" />\
		</div>\
		<div class="cave vsmall">\
			<input type="text" name="costPrice[]" value="$'+txtCost+'" readonly="readonly" />\
		</div>\
		<div class="cave vsmall subTtl"><input type="text" value="$'+subTotal+'" readonly="readonly" /></div>\
		<div class="cave vsmall"><input type="text" name="mealDscnt[]" value="'+discount+'" readonly="readonly" /></div>\
		<div class="cave vsmall subTtl"><input type="text" value="$'+total+'" readonly="readonly" /></div>\
		<div class="cave last"><a id="remove" onclick="return removeItem('+num+');">remove</a></div>\
	</div>');
	
	$("select#slcMealType option:first").attr('selected', 'selected');
	$("select#slcMealItem").html('');
	$("input#txtQnty, input#txtCost, input#subTotal, input#total").val('');
	$("input#discount").val(0);
	
	num++;
}
function check_addMealOrder() {
	var ordrFrom	= $("#ordrFrom").val();
	var prpType		= $("#prpType").val();
	var slcAlloc	= $("#slcAlloc").val();
	
	var slcMealType = $("#slcMealType").val();
		var mealID	= $("#slectedMealID").val();
	var listItem	= $("div.theForm .listItem").height();
	
	if(ordrFrom=="inside") {
		if(prpType.length < 1) {
			$("#error1").css("display", "inline");
			$("#error1").html("Please select property type");
			$("#prpType").css("border-color", "#FF0000");
			return false;
		} else { clearErrors(); }
		
		if(slcAlloc=="---") {
			$("#error2").css("display", "inline");
			$("#error2").html("Select property");
			$("#slcAlloc").css("border-color", "#FF0000");
			return false;
		} else { clearErrors(); }
		
	} else {
		var slcTable	= $("#slcTable").val();
		var takeAway 	= $("#takeAway:checked").val();
		if(slcTable=="---" && takeAway!="on") {
			$("#error3").css("display", "inline");
			$("#error3").html("Please select table");
			return false;
		} else { clearErrors(); }
		
	}
	
	if(listItem<1) {
		$("#error5").css("display", "inline");
		$("#error5").html("You must add at least one item to the list");
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	
	return true;
}
function addDrct4MOrder(){
	var orderID		= $("#orderID").val();
	var invoiceID	= $("#invoiceID").val();
	var reference	= $("#reference").val();
	var mealType	= $("#slcMealType").val();
	var orderType	= $("#orderType").val();
	var mealID		= $("#slcMealItem").val();
	var txtQnty		= $("#txtQnty").val();
	var txtCost		= $("#txtCost").val();
	var subTotal	= Number(txtQnty*txtCost);
	var discount	= $("#discount").val();
	var total		= Number(subTotal-discount);
	
	if(mealType == "---") {
		$("#error4").css("display", "inline");
		$("#error4").html("Select meal package");
		$("#slcMealType").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(mealID == "---") {
		$("#error4").css("display", "inline");
		$("#error4").html("Select meal to add this order");
		$("#slcMealItem").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(txtQnty.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Quantity is missing");
		$("#txtQnty").css("border-color", "#FF0000");
		return false;
	} else if(Number(txtQnty) < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Quantity must be greater than 0");
		$("#txtQnty").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(txtCost.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Price can't be empty");
		$("#txtCost").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$.post("./includes/restaurant.php?action=saveNew&dest=addNew4MealOrder&addedBy="+myUser, { orderID:orderID, invoiceID:invoiceID, reference: reference, orderType:orderType, mealType:mealType, mealID:mealID, txtQnty:txtQnty, txtCost:txtCost, discount:discount }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new meal for this order successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					location.reload();
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
	});
	return false;
}

function delMealFromOrder(detailID, orderID, invoiceID){
	swal({
		title: "Are you sure to delete?",
		text: "You going to remove this meal from this order!",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#DD6B55',
		confirmButtonText: 'Yes, remove it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=deleteRec&dest=delMealOrdrItem",{ detailID:detailID, orderID:orderID, invoiceID:invoiceID }, function(data){
			if(data=="deleted") {
				swal({
					title: "Success",
					text: "Meal you selected has been removed permenantly",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				}, 
					function() {
						location.reload();	
					}
				);
			} else {
				swal("Oops!", data, "error");
			}
		});
	});
	return false;
}
/* --------------------------------------------------------------
------------------------- table management ----------------------
----------------------------------------------------------------- */

function loadTables(pageLimit, perPage) {
	$("div.dynamicData.one #loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+15;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allTables&myRole="+myRole+"&myUser="+myUser,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("div.dynamicData.one #loading").css("display", "none");
			$("div.dynamicData.one .load_more_link").addClass('noneLink');
			$("div.dynamicData.one").append(result);
		},
	});
	return false;
}
function addNewTable() {
	swal({
		title: "Add Table",
		text: 'Give a name to this table',
		type: "input",
		showCancelButton: true,
		closeOnConfirm: false,
		animation: "slide-from-top",
		inputPlaceholder: "required",
	},
	function(tablename) {
		if (tablename === false) return false;
		if (tablename === "") {
			swal.showInputError("Please write table name");
			return false
		}
		$.post("./includes/restaurant.php?action=saveNew&dest=addTable&addedBy="+myUser, { tablename:tablename }, function(data) {
			var addedpos = data.search("added");
			if(addedpos==0) {
				var lastID = data.slice(6,21);
				swal({
					title: "Success!",
					text: "You successfully added new table.",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
				function() {
					window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=tableMgt";
				}
				);
			} else {
				swal("Oops!", data, "error");
			}
		});
	});
	return false;
}
function catchTbl(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getTbl", { recID:recID,myUser:myUser,myRole:myRole }, function(data) {
		$("div.twoCols.one header span").html('[1 row]');
		$("div.dynamicData.one").html(data);
	});
	$("div.suggest.one").css("display", "none");
}
function check_addTable(){
	var tableName	= $("#tableName").val();
	var bColor		= $("#bColor").val();
	var fColor		= $("#fColor").val();
	
   	if(tableName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide table name");
		$("#tableName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
 	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	
	$.post("./includes/restaurant.php?action=saveNew&dest=addTable&addedBy="+myUser, { tableName:tableName, bColor:bColor,  fColor:fColor }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new table successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false,
			},
				function() {
					window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=tableMgt";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function smplfyAddMItem(){
	$("#slcType").change(function(){
		var slcType = $("#slcType").val();
		if(slcType!=""){
			var starTime = endTime = "";
			if(slcType=="morning" || slcType=="custom"){
				var starTime = "05:00"; var endTime = "11:59";
			} else if(slcType=="afternoon"){
				var starTime = "12:00"; var endTime = "17:59";
			} else if(slcType=="evening"){
				var starTime = "18:00"; var endTime = "23:59";
			} else if(slcType=="all-times"){
				var starTime = "00:00"; var endTime = "23:59";
			} else if(slcType=="all-day"){
				var starTime = "05:00"; var endTime = "17:59";
			} else if(slcType=="all-night"){
				var starTime = "18:00"; var endTime = "04:59";
			}
		} else {
			var starTime = endTime = "";
		}
		$("#starTime").val(starTime);
		$("#endTime").val(endTime);
	});
	//
	$("#starTime, #endTime").bind("change, keyup", function() {
		$("#slcType option:last").attr("selected", "selected");
	});
}
function addNewPackage() {
	swal({
		title: "Add Package",
		text: 'Give a name to this meal package',
		type: "input",
		showCancelButton: true,
		closeOnConfirm: false,
		animation: "slide-from-top",
		inputPlaceholder: "required",
	},
	function(package) {
		if (package === false) return false;
		if (package === "") {
			swal.showInputError("Please write Type name");
			return false
		}
 		$.post("./includes/restaurant.php?action=saveNew&dest=addMealPckge&addedBy="+myUser, {package:package}, function(data){
			var addedpos = data.search("added");
			if(addedpos==0) {
				var lastID = data.slice(6,21);
				swal({
					title: "Success!",
					text: "You successfully added new package.",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=mealMgt";
					}
				);
			} else {
				swal("Oops!", data, "error");
			}
		});
	});
	return false;
}
function check_editTable() {
	var tableID		= $("#tableID").val();
	var tblName		= $("#tblName").val(); 		
	var bColor 		= $("#bColor").val();
	var fColor 		= $("#fColor").val();
	var slcStatus 	= $("#slcStatus").val();
	if(tblName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Table name is missing");
		$("#tblName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");
	
	$.post("./includes/restaurant.php?action=updateExist&dest=editTable&updatedBy="+myUser, { tableID:tableID, tblName:tblName,bColor:bColor, fColor:fColor, slcStatus:slcStatus }, function(data) {
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated table details successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=tableMgt";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});
	return false;
}
function delTable(tableID){
	swal({
		title: "Are you sure?",
		text: "You going to delete this Table!",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, delete it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=deleteRec&dest=delTable", { tableID:tableID }, function(data) {
			if(data=="deleted") {
				swal({
					title: "Success!",
					text: "Selected Table  has been deleted.",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=tableMgt";
					}
				);
			} else {
				swal("Oops", data, "error");
			}
		});
	});
	return false;
}
/* --- */
function loadUserTables(pageLimit, perPage) {
	$("div.dynamicData.two #loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+15;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allUsrTbles&myRole="+myRole+"&myUser="+myUser,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("div.dynamicData.two #loading").css("display", "none");
			$("div.dynamicData.two .load_more_link").addClass('noneLink');
			$("div.dynamicData.two").append(result);
		},
	});
	return false;
}
function add2List4UsrTable() {
	var slcTable	= $("#slcTable").val();
	var slcTable2	= $("#slcTable :selected").text();
	
	if(slcTable == "---") {
		$("#error2").css("display", "inline");
		$("#error2").html("Please select table");
		$("#slcTable").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$("div.list").append('<div class="listItem num'+num+'">\
		<div class="cave serial"><input type="hidden" name="tableID[]" value="'+slcTable+'" /></div>\
		<div class="cave jumbo">'+slcTable2+'</div>\
		<div class="cave last"><a id="remove" onclick="return removeItem('+num+');">remove</a></div>\
	</div>');
	
	$("select#slcTable option:first").attr('selected', 'selected');
	
	num++;
	return false;
}
function check_addUserTable() {
	var slcUser		= $("#slcUser").val();
	var listItem	= $("div.theForm .listItem").height();
	
	if(slcUser == "---") {
		$("#error1").css("display", "inline");
		$("#error1").html("Please select waiter");
		$("#slcUser").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(listItem<1) {
		$("#error3").css("display", "inline");
		$("#error3").html("You must assign at least one table to this waiter");
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	
	return true;
}
function addDrct4UsrTable() {
	var slcUser		= $("#slcUser").val();
	var slcTable	= $("#slcTable").val();
	
	if(slcTable == "---") {
		$("#error2").css("display", "inline");
		$("#error2").html("Please select table");
		$("#slcTable").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$.post("./includes/restaurant.php?action=saveNew&dest=addDrct4UsrTable&addedBy="+myUser, { slcUser:slcUser, slcTable:slcTable }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You assigned new table to "+slcUser+" successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					location.reload();
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
	});
	return false;
}
function delUsrTable(recID, username) {
	swal({
		title: "Are you sure?",
		text: "You going to un-assign this table from "+username+"!",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, do it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=deleteRec&dest=delUsrTable", { recID:recID, username:username }, function(data) {
			if(data=="deleted") {
				swal({
					title: "Success!",
					text: "Selected table has been revoked from "+username+".",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						location.reload();
					}
				);
			} else {
				swal("Oops", data, "error");
			}
		});
	});
	return false;
}

/* --------------------------------------------------------------
------------------------ table reservation ----------------------
----------------------------------------------------------------- */

function catchTblRsve(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getTblRsve", { recID:recID,myUser:myUser,myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function updateTbleRsrvBar() {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=setFoundNum&dest=tableRsrve",
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, \
				<a onclick="return loadTblRsrvTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateTbleRsrvBar();
			}, 60000);
		}
	});
}
function loadTblRsrv(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&perPage='+perPage;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allTblRsvs&myRole="+myRole+"&myUser="+myUser,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadTblRsrvTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&perPage='+perPage;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allTblRsvs&myRole="+myRole+"&myUser="+myUser,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header">\
				<div class="cave button">Action</div>\
                <div class="cave lshort">Order No.</div>\
                <div class="cave long">Customer</div>\
                <div class="cave middle">Check In</div>\
                <div class="cave middle">Check Out</div>\
			</div>');
			$("#dataTable").append(result);
			
			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/restaurant.php?action=setFoundNum&dest=tableRsrve",
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function simpfyTbleRsvAdd() {
	$("#srchTable").keyup(function(){
		var srchTable = $("#srchTable").val();
		if(srchTable!="") {
			$("div.suggest.two").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=srchTable4Rsve", { srchTable:srchTable }, function(data){
				$("div.suggest.two").html(data);
			});
		} else { $("div.suggest.two").css("display", "none"); }
		clearErrors();
	});
	
	$("a.addNew").leanModal({top : 160, overlay : 0.6, closeButton: "span.close" });
	$("#txtClient").keyup(function(){
		search_client('tableReserve');
	});
	
	var later1year = Number(thisYear)+1;
	var later2year = Number(thisYear)+2;
	
	var picker = new Pikaday({
		field: document.getElementById("dateIn"),
		firstDay: 6,
		minDate: new Date(today),
		yearRange: [thisYear,later1year],
	});
	var picker2 = new Pikaday({
		field: document.getElementById("dateOut"),
		firstDay: 6,
		minDate: new Date(today),
		yearRange: [thisYear,later2year],
	});
}
function catchTable4Rsrve(tableID, tableName) {	
	$("input#tableID").val(tableID);
	$("input#srchTable").val(tableName);
	$("div.suggest").css("display", "none");
}
function check_addTbleRsv() {
	var clientID	= $("#clientID").val();  
	var txtClient	= $("#txtClient").val();
	var tableID		= $("#tableID").val();
	var srchTable	= $("#srchTable").val();
	
	var dateIn		= $("#dateIn").val();
	var dateOut		= $("#dateOut").val();
	var timeIn		= $("#timeIn").val();
	var timeOut		= $("#timeOut").val();
	var txtRemarks	= $("#txtRemarks").val();
	
	if(clientID.length < 1 || txtClient.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please select customer");
		$("#txtClient").css("border-color", "#FF0000");
		$("div.suggest.one").css("display", "none");
		if(window.innerWidth<=768) { $('html, body').animate({ scrollTop: $(".record.one").offset().top }, 'slow'); }
		return false;
	} else { clearErrors(); }
	
	if(tableID.length < 1 || srchTable.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Please select table");
		$("#srchTable").css("border-color", "#FF0000");
		$("div.suggest.two").css("display", "none");
		if(window.innerWidth<=768) { $('html, body').animate({ scrollTop: $(".record.two").offset().top }, 'slow'); }
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	
	$.post("./includes/restaurant.php?action=saveNew&dest=addTbleRsv&addedBy="+myUser, { clientID:clientID, tableID:tableID, dateIn:dateIn, dateOut:dateOut, timeIn:timeIn, timeOut:timeOut, txtRemarks:txtRemarks }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You add new table reservation successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=tableRsrve\
					&action=showInfo&recID="+lastID;
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;	
}
function check_editTbleRsv() {
	var orderID	    = $("#orderID").val();
    var clientID	= $("#clientID").val();  	
	var txtClient	= $("#txtClient").val();
	var tableID		= $("#tableID").val();
	var srchTable	= $("#srchTable").val();
	
	var dateIn		= $("#dateIn").val();
	var dateOut		= $("#dateOut").val();
	var timeIn		= $("#timeIn").val();
	var timeOut		= $("#timeOut").val();
	var txtRemarks	= $("#txtRemarks").val();
	
	if(clientID.length < 1 || txtClient.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please select customer");
		$("#txtClient").css("border-color", "#FF0000");
		$("div.suggest.one").css("display", "none");
		if(window.innerWidth<=768) { $('html, body').animate({ scrollTop: $(".record.one").offset().top }, 'slow'); }
		return false;
	} else { clearErrors(); }
	
	if(tableID.length < 1 || srchTable.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Please select table");
		$("#srchTable").css("border-color", "#FF0000");
		$("div.suggest.two").css("display", "none");
		if(window.innerWidth<=768) { $('html, body').animate({ scrollTop: $(".record.two").offset().top }, 'slow'); }
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");
	
	$.post("./includes/restaurant.php?action=updateExist&dest=editTbleRsv&updatedBy="+myUser, { orderID:orderID, clientID:clientID, tableID:tableID, dateIn:dateIn, dateOut:dateOut, timeIn:timeIn, timeOut:timeOut, txtRemarks:txtRemarks }, function(data) {
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated table details successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=tableRsrve";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});
	return false;
}
function delTblRsve(orderID){
	swal({
	  title: "Are you sure?",
	  text: "You going to delete this Table Order!",
	  type: "warning",
	  showCancelButton: true,
	  confirmButtonColor: '#6d3179',
	  confirmButtonText: 'Yes, delete it!',
	  closeOnConfirm: false
	},
	function() {
	  $.post("./includes/restaurant.php?action=deleteRec&dest=delTblRsve", { orderID:orderID }, function(data) {
		  if(data=="deleted") {
			  swal({
				  title: "Success!",
				  text: "Selected Table Order has been deleted.",
				  type: "success",
				  timer: 1500,
				  showConfirmButton: false
			  },
				  function() {
					  window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=tableRsrve";
				  }
			  );
		  } else {
			  swal("Oops", data, "error");
		  }
	  });
	});
	return false;
}

/* ---------------------------------------------------------------
---------------------------- cashier ----------------------------
-----------------------------------------------------------------*/

function catchRecpt(recID) {
	$.post("./includes/restaurant.php?action=get_recInfo&dest=getRecpt", { recID:recID, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function updateRecptBar() {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	var dataString = 'myRole='+ myRole+'&myWhouse='+ myWhouse;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=setFoundNum&dest=receipts",
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, \
				<a onclick="return loadRecptsTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateRecptBar();
			}, 60000);
		}
	});
}
function loadRecpts(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allRecpts&myRole="+myRole+"&myWhouse="+myWhouse,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadRecptsTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allRecpts&myRole="+myRole+"&myWhouse="+myWhouse,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header"><div class="cave short">Order No.</div>\
                <div class="cave lmiddle">Order Details</div>\
                <div class="cave lmiddle">Waiter or Added By</div>\
                <div class="cave lshort">Amount</div>\
                <div class="cave lshort">Balance</div>\
                <div class="cave button">Action</div></div>');
			$("#dataTable").append(result);
			
			(function (){
				//
				var dataString = 'myRole='+ myRole+'&myWhouse='+ myWhouse;
				$.ajax({
					type: "POST",
					url: "./includes/restaurant.php?action=setFoundNum&dest=receipts",
					data: dataString,
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function simplifyCashierAdd() {
	$("input#txtOrder").keyup(function(){
		var txtOrder = $("#txtOrder").val();
		if(txtOrder!="") {
			$("div.suggest.one").css("display", "table-row");
			$.post("./includes/restaurant.php?action=searchRec&dest=order4Receipt", { txtOrder:txtOrder, myRole:myRole }, function(data) {
				$("div.suggest.one").html(data);
			});
		} else { $("div.suggest.one").css("display", "none"); }
	   clearErrors();
	});
	//
	$("#slcBankID").change(function() {
		var bankID = $("#slcBankID").val();
		if(bankID=="") {
			$("#slcBankAcc").html('');
		} else {
			$.post("./includes/finance.php?action=searchRec&dest=myBankAccs",{bankID:bankID,myWhouse:myWhouse},function(data){
				$("#slcBankAcc").html(data);
			});
		}
	});
	//
	$("#txtAmount").keyup(function() {
		inWords($("#txtAmount").val());
	});
	$("#txtAmount").change(function() {
		inWords($("#txtAmount").val());
	});
	//
	$("#txtRemarks").keyup(function(){
		return tweetFeed(this, 500);
	});
	//
	//
	var kahor1sano = Number(sanadkan)-1;
	var picker = new Pikaday({
		field: document.getElementById("transDate"),
		firstDay: 6,
		maxDate: new Date(maanta),
		yearRange: [kahor1sano,sanadkan],
	});
}
function catchOrd4Recpt(orderID, invocID, totalDue, balance, orderDeatils) {
	$("#orderID").val(orderID);
	$("#invoiceID").val(invocID);
	$("#txtOrder").val(orderID);
	$("#totalDue").val(totalDue);
	$("#balance").val(balance);
	$("p#pNumber").html('#'+orderID);
	$("p#pTAmount").html('$'+totalDue);
	$("p#pBalance").html('$'+balance);
	$("div.displayInfo").css("display", "inline");
	$("div.suggest").css("display", "none");
}
function check_addCashier() {
	var orderID		= $("#orderID").val();
	var invoiceID	= $("#invoiceID").val();
	var txtOrder	= $("#txtOrder").val();
	var totalDue	= parseFloat($("#totalDue").val());
	var balance		= parseFloat($("#balance").val());
	
	var txtAmount	= $("#txtAmount").val();
	var txtInWords	= $("#txtInWords").val();
	
	var slcBankID	= $("#slcBankID").val();
	var slcBankAcc	= $("#slcBankAcc").val();
	var txtCheque	= $("#txtCheque").val();
	
	var txtPaidBy	= $("#txtPaidBy").val();
	var txtRemarks	= $("#txtRemarks").val();
	var transDate	= $("#transDate").val();
	
	if(orderID.length < 1 || invoiceID.length < 1 || txtOrder.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please find and select meal order");
		$("#txtOrder").css("border-color", "#FF0000");
		$("div.suggest").css("display", "none");
		return false;
	} else { clearErrors(); }
	
	if(txtAmount.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Amount value is missing");
		$("#txtAmount").css("border-color", "#FF0000");
		return false;
	} else if(Number(txtAmount) < 0.1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Amount must be greater than 0");
		$("#txtAmount").css("border-color", "#FF0000");
		return false;
	} else if(parseFloat(txtAmount) > parseFloat(balance)) {
		$("#error2").css("display", "inline");
		$("#error2").html("Amount can't be more than $"+balance);
		$("#txtAmount").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(slcBankID.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("Please select bank");
		$("#slcBankID").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(slcBankAcc=="---" || slcBankAcc.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("Select bank account");
		$("#slcBankAcc").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	if(txtPaidBy.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("This field can't be empty");
		$("#txtPaidBy").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }
	
	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");
	
	$.post("./includes/restaurant.php?action=saveNew&dest=addCashier&addedBy="+myUser, { myWhouse:myWhouse, orderID:orderID, invoiceID:invoiceID, txtAmount:txtAmount, balance:balance, txtInWords:txtInWords, slcBankID:slcBankID, slcBankAcc:slcBankAcc, txtCheque:txtCheque, txtPaidBy:txtPaidBy, txtRemarks:txtRemarks, transDate:transDate }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added receipt record successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=cashier&action=showInfo&recID="+lastID;
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;	
}
/*function editOrderType(orderID,orderType){
	if(orderType=="eatHere"){
		var changeTo ='Take Away';
	} else { var changeTo ='Eat Here'; }
	
	swal({
		title: "Are you sure?",
		text: "You going to change this meal order type to "+changeTo,
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, change it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=updateExist&dest=editOrderType&updatedBy="+myUser, { orderID:orderID,orderType:orderType }, function(data) {
			if(data=="updated") {
				swal({
					title: "Success!",
					text: "Meal order type has been changed.",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						location.reload();
					}
				);
			} else {
				swal("Oops", data, "error");
			}
		});
	});
	return false;	
}*/
$("a.payRstBlance.orderID").live("click", function() {
	var orderID		= $(this).parents("div.cave.button").parent("div.record").find("input#orderID").val();
	var txtDigit	= $(this).parents("div.cave.button").parent("div.record").find("input#txtDigit").val();
	var txtAmount	= parseFloat($(this).parents("div.cave.button").parent("div.record").find("input#txtAmount").val());
	var balance		= parseFloat($(this).parents("div.cave.button").parent("div.record").find("input#balance").val());
	var orderFrom	= $(this).parents("div.cave.button").parent("div.record").find("input#orderFrom").val();
	
	if(txtDigit.length < 1) {
		swal("Oops", "Last four digits is empty", "error");
		$(this).parents("div.cave.button").parent("div.record").find("input#txtDigit").css("border", "1px solid #f00");
		return false;
	}
	
	if(txtAmount > balance) {
		swal("Oops", "Amount can't be greater than $"+balance, "error");
		$(this).parents("div.cave.button").parent("div.record").find("input#txtAmount").css("border", "1px solid #f00");
		return false;
	}
	/*if((orderFrom=="inside")&&(txtAmount != balance)) {
		swal("Oops", "Amount can't be less than $"+balance, "error");
		$(this).parents("div.cave.button").parent("div.record").find("input#txtAmount").css("border", "1px solid #f00");
		return false;
	}*/
	if((orderFrom=="inside")&&(txtAmount<0.1)) {
		swal("Oops", "Amount can't be 0", "error");
		$(this).parents("div.cave.button").parent("div.record").find("input#txtAmount").css("border", "1px solid #f00");
		return false;
	}
	swal({
		title: "Are you sure?",
		text: "You going to collect balance amount of this order",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, collect it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=updateExist&dest=payRstBlance&updatedBy="+myUser, { myRole:myRole, orderID:orderID, txtAmount:txtAmount, txtDigit:txtDigit,  myWhouse:myWhouse }, function(data) {
			var addedpos = data.search("updated");
			var addedVat = data.search("addedVat");
			if(addedpos==0) {
				var lastID = data.slice(8,25);
				swal({
					title: "Success!",
					text: "You collected sum of $"+txtAmount+" for orderID = "+orderID+".",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=mealOrder&action=showRecpt\
						&recID="+lastID;
					}
				);
			}else if(addedVat==0) {
				swal({
					title: "Success!",
					text: "You collected sum of $"+txtAmount+" for orderID = "+orderID+".",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=mealOrder";
					}
				);
			} else {
				swal("Oops", data, "error");
			}
		}); 
	});
	return false;
});
// get receipt for book 
$("a.payRstBlance.book").live("click", function() {
	var clientID	= $(this).parents("div.cave.button").parent("div.record").find("input#clientID").val();
	var txtDigit	= $(this).parents("div.cave.button").parent("div.record").find("input#txtDigit").val();
	var txtAmount	= parseFloat($(this).parents("div.cave.button").parent("div.record").find("input#txtAmount").val());
	var balance		= parseFloat($(this).parents("div.cave.button").parent("div.record").find("input#balance").val());
	
	if(txtAmount > balance) {
		swal("Oops", "Amount can't be greater than $"+balance, "error");
		$(this).parents("div.cave.button").parent("div.record").find("input#txtAmount").css("border", "1px solid #f00");
		return false;
	}
	swal({
		title: "Are you sure?",
		text: "You going to collect balance amount of this customer",
		type: "warning",
		showCancelButton: true,
		confirmButtonColor: '#6d3179',
		confirmButtonText: 'Yes, collect it!',
		closeOnConfirm: false
	},
	function() {
		$.post("./includes/restaurant.php?action=saveNew&dest=colectBookBlance&addedBy="+myUser, { clientID:clientID, txtAmount:txtAmount, myWhouse:myWhouse }, function(data) {
			var addedpos = data.search("updated");
			if(addedpos==0) {
				var lastID = data.slice(8,25);
				swal({
					title: "Success!",
					text: "You collected sum of $"+txtAmount+" for this customer.",
					type: "success",
					timer: 1500,
					showConfirmButton: false
				},
					function() {
						window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=mealOrder&action=showRecpt\
						&recID="+lastID;
					}
				);
			} else {
				swal("Oops", data, "error");
			}
		});
	});
	return false;
});

/* ------------------------------------------------------------
----------------------------- KOS  ----------------------------
-------------------------------------------------------------- */

function updateKosBar() {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=setFoundNum&dest=kos",
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, <a onclick="return loadKosOrderTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateKosBar();
			}, 60000);
		}
	});
}
function loadKosOrder(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allkos&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadKosOrderTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/restaurant.php?action=loadTable&dest=allkos&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header"><div class="cave long">Item</div><div class="cave short">QTY</div><div class="cave lmiddle">Status</div><div class="cave button">Action</div></div>');
			$("#dataTable").append(result);
			
			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/restaurant.php?action=setFoundNum&dest=kos",
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function kosProcess(orderID, detailID){
	$.post("./includes/restaurant.php?action=updateExist&dest=editKos&updatedBy="+myUser,{orderID:orderID,detailID:detailID}, function(data){
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated successfully.",
				type: "success",
				timer: 1500,
				showConfirmButton: false
			},
				function() {
					window.location = "./workplace.php?role="+myRole+"&task=bar&subtask=kos";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
	});
	return false;
}

/* ------------------------------------------------------------
----------------------------- Waiter  ----------------------------
-------------------------------------------------------------- */

function simplyMealOrder4W() {
	$("div.tables").find("div.table:first-child input[type='radio']").attr("checked", true);
	$('input#txt4digits').attr("readonly", true);
	//
	$("#checkAway, #switchAway").click(function(){ 
		$('div#switchAway').toggleClass("switchOn");
		if(document.getElementById("eatTable").checked == true) {
			document.getElementById("eatTable").checked = false;
			$("div.tables").find("div.table input[type='radio']").attr("checked", false);
			$("span#checkAway").html("Take Away");
		} else {
			document.getElementById("eatTable").checked = true;
			$("div.tables").find("div.table:first-child input[type='radio']").attr("checked", true);
			$("span#checkAway").html("Table");
		}
	});
	$("div.tables").click(function(){
		$('div#switchAway').addClass("switchOn");
		document.getElementById("eatTable").checked = true;
		$("span#checkAway").html("Table");
	});
	$("div.filter").click(function(){
		$('div.selects select').css("display", "none");
		if($(this).hasClass('property')) {
			$('div.filter').removeClass("property");
			$('div.filter').addClass("book");
			$('select#slcClient').css("display", "inline");
			//document.getElementById("eatTable").checked = true;
			//$("span#checkAway").html("Table");
			//$('div#switchAway').addClass("switchOn");
		} else {
			$('div.filter').removeClass("book");
			$('div.filter').addClass("property");
			$('select#prpType, select#slcAlloc').css("display", "inline");
		}
	});
	//
	$("select#prpType").change(function() {
		$("div.tables").find("div.table input[type='radio']").attr("checked", false);
		$('div#switchAway').removeClass("switchOn");
		document.getElementById("eatTable").checked = false;
		var prpType = $("#prpType").val();
		$.post("./includes/restaurant.php?action=searchRec&dest=getAlloc4Meal", { prpType: prpType }, function(data) {
			$("select#slcAlloc").html(data);
		});
		clearErrors();
	});
	//
	$("select#slcAlloc").change(function() {
		$("div.tables").find("div.table input[type='radio']").attr("checked", false);
		$('div#switchAway').removeClass("switchOn");
		document.getElementById("eatTable").checked = false;
	});
	//
	$("div.package").click(function() {
		var packageID	= $(this).children("label").find("#packageID").val();
		$.post("./includes/restaurant.php?action=searchRec&dest=getMealItems4Pckge", { packageID: packageID }, function(data) {
			$("div.record.three div.mealPart.left").html(data);
		});
		return false;
	});
	//
	$("div.mealItem div.itemPart:first-child, a.addToCart").live('click', function() {
		var itemID		= $(this).parents('div.mealItem').find("input#itemID").val(); 
		var packageID	= $(this).parents('div.mealItem').find("input#packageID").val(); 
		var mealItem	= $(this).parents('div.mealItem').find("p.meal.item").html();
		var txtQnty		= $(this).parents('div.mealItem').find("input#txtQnty").val();
		var costPrice	= $(this).parents('div.mealItem').find("input#costPrice").val();
		var imgSrc		= $(this).parents('div.mealItem').find("img").attr('src');
		
		var mealExist	= $('div.mealPart.center').find('div.slctedMeal').height();
		if(mealExist	== null) {
			$("div.mealPart.center").append('<div class="slctedMeal header">\
            	<div class="selected">Selected Meals</div>\
				<div class="selected quantity">Qty</div>\
            </div>');
		}
		var itemID2		= itemID.trim();
		var prdAdded	= $("input#mealID", list);
		if((!prdAdded.is("*") || !prdAdded.filter(function(i, el){return el.value.indexOf(itemID2) > -1}).is("*"))) {
			$("div.mealPart.center").append('<div class="slctedMeal item">\
				<input type="hidden" name="recordType[]" value="new" />\
				<input type="hidden" name="packageID[]" value="'+packageID+'" />\
				<input type="hidden" id="mealID" name="mealID[]" value="'+itemID+'" />\
				<input type="hidden" name="mealQnty[]" value="'+txtQnty+'" />\
				<input type="hidden" name="costPrice[]" value="'+costPrice+'" />\
				<div class="selected">\
					<img src="'+imgSrc+'" />\
					<span>'+mealItem+'</span>\
				</div>\
				<div class="selected quantity">'+txtQnty+'</div>\
				<div class="selected remove new"><i class="fa fa-close"></i></div>\
			</div>');
		
		} else {
			swal("Oops", mealItem + " has already been added to list", "error");
		}
		return false;
	});
	//
	$("div.mealPart.center div.remove.new").live('click', function() {
		$(this).parent(".slctedMeal").find("input").val("");
		$(this).parent(".slctedMeal").fadeOut(500, function(){ $(this).remove(); });
		return false
	});
	//
	$("#checkDRcpt, #switchRcpt").click(function(){ 
		$('div#switchRcpt').toggleClass("switchOn");
		$('input#txt4digits').val('');
		if(document.getElementById("directRcpt").checked == true) {
			document.getElementById("directRcpt").checked = false;
			$('input#txt4digits').attr("readonly", true);
		} else {
			document.getElementById("directRcpt").checked = true;
			$('input#txt4digits').attr("readonly", false);
		}
	});
}
function check_addWMealOrder() {
	var eatTable	= $("#eatTable:checked").val();
	var byBook		= $("div.filter.book").val();
	//
	var prpType		= $("#prpType").val();
	var slcAlloc	= $("#slcAlloc").val();
	var mealType	= $("#mealType").val();
	var slcClient	= $("#slcClient").val();
	//
	if (eatTable	== "on") {
		var mealType	= $("#mealType").height();
		if (mealType 	== null) {
			swal("Oops", "Please select table", "error");
			return false;
		}
	}
	//
	if(prpType 		!= "" && slcAlloc == "---") {
		$("#slcAlloc").css("border-color", "#FF0000");
		swal("Oops", "Please select property to serve", "error");
		return false
	} else { $("#slcAlloc").css("border-color", "#cccccc"); }
	
	//
	/*if(slcClient == "" && byBook == "") {
		$("#slcClient").css("border-color", "#FF0000");
		swal("Oops", "Please select customer", "error");
		return false
	} else { $("#slcClient").css("border-color", "#cccccc"); }*/
	
	var listItem	= $("div.mealPart.center div.slctedMeal.item").height();
	
	if(listItem<1) {
		swal("Oops", "You must add at least one meal item to this order", "error");
		$("#error5").html("");
		return false;
	}
	
	return true;
}
function check_addWMealItem() {
	var listItem	= $("div.mealPart.center div.slctedMeal.item").height();
	if(listItem<1) {
		swal("Oops", "You must add at least one meal item to this order", "error");
		return false;
	}
	$("button#btnUpdate").html('Wait..');
	$("button#btnUpdate").attr('disabled', true);
	return true;
}
/* ------------------------------------------------------------
----------------------------- Report  ----------------------------
-------------------------------------------------------------- */
function resetRptFilter() {
	$("div.filter").css("display", "none");
	$("div.filter.byCashierActvty").css("display", "inline");
	$("div.filter.byDate").css("display", "inline");
}
function resetRptError() {
	$("div.filter input, div.filter select").css("border","1px solid #ccc");
	$("label.error").css("display", "none");	
}
function resetError() {
	$("div.reportArea input[type='text'], div.reportArea input[type='month']").css("border-color", "#ccc");
	$("div.reportArea select").css("border-color", "#ccc");
	$("div.reportArea label.error").css("display", "none");
}
function catchCashier4Rpt(empID, empName,username) {
	$("#CashierID").val(empID);
	$("#txtCashier").val(empName);
	$("#username").val(username);
	$("div.suggest").css("display", "none");
}
function simplifyBarReport(){
	//
	$("div.filter.byCashier").css("display", "inline");
	 
 	$("div.reportArea label, div.reportArea input[type='radio']").click(function() {
		resetError();
		$("div.rprtType").find("input[type='radio']").attr("checked", false);
		$(this).parents("div.rprtType").find("input[type='radio']").attr("checked", true);
		$("div.filter").css("display", "none");
		
		
 		var rptType = $("input[name='reportType']:checked").val();
		if(rptType=="cashierActvty") {
			$("div.filter.byCashier").css("display", "inline");
			$("div.filter.byDate").css("display", "inline");
 		} else if(rptType=="waiterActvty") {
			$("div.filter.byWaiter").css("display", "inline");
			$("div.filter.byDate").css("display", "inline");
		} else if(rptType=="SalesMade") {
			$("div.filter.bySlsReport").css("display", "inline");
			$("div.filter.byDate").css("display", "inline");
 		} else if(rptType=="sales") {
			$("div.filter.bySales").css("display", "inline");
 		} else if(rptType=="topTen") {
			$("div.filter.byTop").css("display", "inline");
		} else if(rptType=="myStore") {
			$("div.filter.byStore").css("display", "inline");
		} else if(rptType=="gPayable") {
			$("div.filter.byGoods").css("display", "inline");
 		} 
		if(rptType!="sales") {
			$("div.filter.byDate").css("display", "inline");
		} 
		resetError();
	});
	//
	var picker = new Pikaday({
		field: document.getElementById("startDate"),
		firstDay: 6,
		maxDate: new Date(today),
		yearRange: [2017,thisYear],
	});
	var picker2 = new Pikaday({
		field: document.getElementById("endDate"),
		firstDay: 6,
		maxDate: new Date(today),
		yearRange: [2017,thisYear],
	});
	var startDate,
    endDate,
    updateStartDate = function() {
		startPicker.setStartRange(startDate);
        endPicker.setStartRange(startDate);
        endPicker.setMinDate(startDate);
    },
    updateEndDate = function() {
		startPicker.setEndRange(endDate);
        startPicker.setMaxDate(endDate);
        endPicker.setEndRange(endDate);
    },
    startPicker = new Pikaday({
		field: document.getElementById("startDate"),
        maxDate: new Date(today),
		yearRange: [2017,thisYear],
        onSelect: function() {
			startDate = this.getDate();
            updateStartDate();
        }
    }),
    endPicker = new Pikaday({
		field: document.getElementById('endDate'),
        minDate: new Date(),
        maxDate: new Date(today),
		yearRange: [2017,thisYear],
        onSelect: function() {
			endDate = this.getDate();
            updateEndDate();
        }
    }),
    _startDate = startPicker.getDate(),
    _endDate = endPicker.getDate();
	if (_startDate) {
		startDate = _startDate;
        updateStartDate();
    }
	if (_endDate) {
		endDate = _endDate;
        updateEndDate();
    
    }
}
function check_reportBarParam(){
	resetError();
	var rptType 	= $("input[name='reportType']:checked").val();
 	 
	var startDate	= $("input#startDate").val();
	var endDate		= $("input#endDate").val();
	//
	var slcCashier	 = $("select#slcCashier").val();
	var slcWaiter	 = $("select#slcWaiter").val();
	var slcSlsReport = $("select#slcSlsReport").val();
	var slcSales	 = $("select#slcSales").val();
	var slcTop		 = $("select#slcTop").val();
	var slcStore		 = $("select#slcStore").val();
	var byGoods		 = $("select#byGoods").val();
 	
	if(rptType=="cashierActvty") {
		if(slcCashier=="") {
			$("#error1").css("display", "inline");
			$("#error1").html("Please select cashier");
			$("select#slcCashier").css("border-color", "#FF0000");
			return false;
		} else { resetError(); }
	}
	if(rptType=="waiterActvty") {
		if(slcWaiter=="") {
			$("#error1").css("display", "inline");
			$("#error1").html("Please select waiter");
			$("select#slcWaiter").css("border-color", "#FF0000");
			return false;
		} else { resetError(); }
	}
	if(rptType=="myStore") {
		if(slcStore=="") {
			$("#error1").css("display", "inline");
			$("#error1").html("Please select waiter");
			$("select#slcStore").css("border-color", "#FF0000");
			return false;
		} else { resetError(); }
	}
	
 	if(rptType!="sales") {
		if(startDate.length<1) {
			$("#error1").css("display", "inline");
			$("#error1").html("Please select begining date");
			$("input#startDate").css("border-color", "#FF0000");
			return false;
		} else { resetError(); }
		
		if(endDate.length<1) {
			$("#error1").css("display", "inline");
			$("#error1").html("Please select ending date");
			$("input#endDate").css("border-color", "#FF0000");
			return false;
		} else { resetError(); }
	} 
		
	return true;
}
//
 