function check_searchBox() {
	// search supply items
	$("input#srchSupplyItems").keyup(function() {
		var passedValue = $("input#srchSupplyItems").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/supply.php?action=searchRec&dest=srchSupplyItems", { passedValue: passedValue }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchSupplyItems").blur(function() {
		if($("#srchSupplyItems").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
	// search purchase supply
	$("input#srchSuplyPrchse").keyup(function() {
		var passedValue = $("input#srchSuplyPrchse").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/supply.php?action=searchRec&dest=srchSuplyPrchse", { passedValue: passedValue  }, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchSuplyPrchse").blur(function() {
		if($("#srchSuplyPrchse").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
		// search purchase supply
	$("input#srchSupplyUsage").keyup(function() {
		var passedValue = $("input#srchSupplyUsage").val();
		if(passedValue.val!="") {
			$("div.suggest").css("display", "table-row");
			$.post("./includes/supply.php?action=searchRec&dest=srchSupplyUsage", { passedValue: passedValue}, function(data) {
				$("div.suggest").html(data);
			});
		}
	});
	$("input#srchSupplyUsage").blur(function() {
		if($("#srchSupplyUsage").val()=="") {
			$("div.suggest").css("display", "none");
		}
	});
}
/* ------------------------------------------------------------
------------------------- measurements -------------------------
--------------------------------------------------------------*/
function updateMeasureBar() {
	var perPage = $("#slcPerPage").val();
	var count = $("label#count").html();
	$.ajax({
		type: "POST",
		url: "./includes/inventory.php?action=setFoundNum&dest=measures",
		cache: false,
		timeout: 2000,
		success: function(result){
			if(result != count){
				$("#refresh").html('records changed, <a onclick="return loadMeasuresTwo(0,'+perPage+');">refresh now!</a>');
				(function blink(){
					$("span#refresh a").fadeOut(500).fadeIn(500, blink);
				})();
			}
			setTimeout(function(){
				updateMeasureBar();
			}, 60000);
		}
	});
}
function loadMeasures(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/inventory.php?action=loadTable&dest=allMeasures&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadMeasuresTwo(pageLimit, perPage) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+ pageLimit+'&perPage='+ perPage;
	$.ajax({
		type: "POST",
		url: "./includes/inventory.php?action=loadTable&dest=allMeasures&myUser="+myUser+"&myRole="+myRole,
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").html('<div id="record" class="header"> <div class="cave button">Action</div>\
                <div class="cave long">Measure Name</div>\
                <div class="cave middle">Unit Converstion</div>\
                <div class="cave lshort">Status</div></div>');
			$("#dataTable").append(result);

			(function (){
				//
				$.ajax({
					type: "POST",
					url: "./includes/inventory.php?action=setFoundNum&dest=measures",
					cache: false,
					timeout: 2000,
					success: function(numRecs){
						$("#foundNum").html('<label id="count">'+numRecs+'</label> record(s) has been found\
						<span id="refresh"></span>');
					}
				});
				//
			})();
		},
	});
	return false;
}
function catchMsure(recID) {
	$.post("./includes/inventory.php?action=get_recInfo&dest=getMsure", { recID:recID, myUser:myUser, myRole:myRole }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function check_addMeasure() {
	var shortName = $("#shortName").val();
	var longName  = $("#longName").val();
	var Unitconv  = $("#Unitconv").val();
	var slcSmallUnit  = $("#slcSmallUnit").val();
	var slcUnitType = $("#slcUnitType").val();
	var sameUnit	= $("input#sameUnit:checked").val();
	if(sameUnit!="on") { var sameUnit="0"; } else { var sameUnit="1"; }

	if(shortName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide short name");
		$("#shortName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(longName.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("provide long name");
		$("#longName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(Unitconv.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("provide unit converstion");
		$("#Unitconv").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(slcSmallUnit==null && sameUnit==0) {
		$("#error5").css("display", "inline");
		$("#error5").html("select smallest unit or check same unit");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	$.post("./includes/inventory.php?action=saveNew&dest=addMeasure&addedBy="+myUser, { shortName:shortName, longName:longName, Unitconv:Unitconv, slcUnitType:slcUnitType, slcSmallUnit:slcSmallUnit, sameUnit:sameUnit}, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new measurement record successfully.",
				icon: "success",
				timer: 1500,
				button: false,
			})
				.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=supply&subtask=supplyPrchse&action=addnew";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnSave").attr("disabled", false);
		$("#btnSave").html("Save");
	});
	return false;
}
function check_editMeasure() {
	var msrID 		= $("#msrID").val();
	var shortName = $("#shortName").val();
	var longName  = $("#longName").val();
	var Unitconv  = $("#Unitconv").val();
	var slcUnitType = $("#slcUnitType").val();
	var txtSmall = $("#txtSmall").val();
	var smallUnit = $("#smallUnit").val();
	var oldUnit = $("#oldUnit").val();
	var sameUnit	= $("input#sameUnit:checked").val();
	if(sameUnit!="on") { var sameUnit="0"; } else { var sameUnit="1"; }
	var msrUsed = $("#msrUsed").val();
	var smallUnitTxt =  $("#smallUnit :selected").text()
	if (!smallUnitTxt) smallUnitTxt = "";

	if(shortName.length < 1 || msrID=="") {
		$("#error1").css("display", "inline");
		$("#error1").html("Please provide short name");
		$("#shortName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(longName.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("provide long name");
		$("#longName").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(Unitconv.length < 1) {
		$("#error3").css("display", "inline");
		$("#error3").html("provide unit converstion");
		$("#Unitconv").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

	$.post("./includes/inventory.php?action=updateExist&dest=editMeasure&updatedBy="+myUser, { msrID:msrID, shortName:shortName, longName:longName, Unitconv:Unitconv, slcUnitType:slcUnitType, txtSmall:txtSmall, sameUnit:sameUnit, smallUnit:smallUnit, oldUnit:oldUnit, msrUsed:msrUsed, smallUnitTxt:smallUnitTxt}, function(data) {
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated measure record successfully.",
				icon: "success",
				timer: 1500,
				button: false,
			})
				.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=inventory&subtask=measures";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});
	return false;
}
function delMeasure(msrID) {

	swal({
		title: "Are you sure?",
		text: "You going to delete this measurement!",
		icon: "warning",
		dangerMode:true,
		buttons:["Cancel","'Yes, remove it!"],
		closeOnConfirm: false
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/supply.php?action=deleteRec&dest=delMeasure", { msrID:msrID }, function(data) {
				if(data=="deleted") {
					swal({
						title: "Success!",
						text: "Selected measurement record has been deleted.",
						icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
						location.reload();
					});

				} else {
					swal("Oops", data, "error");
				}
			});
		}
	});
	return false;
}
///
function loadSupplyPrchse(pageLimit, perPage, period) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&period='+period+'&perPage='+perPage;
	$.ajax({
		type: "POST",
		url: "./includes/supply.php?action=loadTable&dest=allSupplyPrchse",
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function loadSupplyItems(pageLimit, perPage, period) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&period='+period+'&perPage='+perPage;
	$.ajax({
		type: "POST",
		url: "./includes/supply.php?action=loadTable&dest=allSupplyItems",
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}

function loadSupplyUsage(pageLimit, perPage, period) {
	$("#dataTable div#loading").css("display", "inline");
	var dataString = 'pageLimit='+pageLimit+'&period='+period+'&perPage='+perPage;
	$.ajax({
		type: "POST",
		url: "./includes/supply.php?action=loadTable&dest=allSupplyUsage",
		data: dataString,
		cache: false,
		timeout: 2000,
		success: function(result){
			$("#dataTable div#loading").css("display", "none");
			$(".load_more_link").addClass('noneLink');
			$("#dataTable").append(result);
		},
	});
	return false;
}
function addSupplyMsureInPopup() {
	var slcUnits = $("#slcUnits").val();
	var slcMsrmnt = $("#slcMsrmnt").val();
	var supItemID = $("#supItemID").val();
	var isDefualt	= $("input#isDefualt:checked").val();

	if(isDefualt!="on") { var isDefualt="No"; } else { var isDefualt="Yes"; }

	if(slcUnits.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Select unit type");
		$("#slcUnits").addClass("highlight");
		return false;
	} else { clearErrors(); }

	if(slcMsrmnt.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Select measurement");
		$("#slcMsrmnt").addClass("highlight");
		return false;
	} else { clearErrors(); }

	$("#btnAdd").attr("disabled", true);
	$("#btnAdd").html("wait...");
	$.post("./includes/supply.php?action=saveNew&dest=addSupplyMsureInPopup", { supItemID:supItemID, slcMsrmnt:slcMsrmnt,isDefualt:isDefualt }, function(data) {
		var addedpos = data.search("added");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new measurement successfully.",
				icon: "success",
						timer: 1500,
						button: false
				})
					.then(value=> {
					location.reload();
				}
			);
 		} else {
			swal("Oops!", data, "error");
		}
		$("#addToList").attr("disabled", false);
	});
	return false;
}

function delSupplyPrdctMsure(recNum, msrID, supItemID) {
	swal({
		title: "Are you sure to delete?",
		text: "You going to remove this measurement for this product.",
		icon: "warning",
		dangerMode:true,
		buttons: ["Cancel","Yes, delete it!"]
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/supply.php?action=deleteRec&dest=delSupplyPrdctMsure",{msrID:msrID, supItemID:supItemID}, function(data){
				if(data=="deleted") {
					swal({
						title: "Success",
						text: "Measurement you selected has been removed permenantly",
						icon: "success",
							timer: 1500,
							button: false
					})
						.then(value=> {
						location.reload();
					});
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
	return false;
}

function check_editSupplyProduct() {
	var supItemID 		= $("#supItemID").val();
	var txtName		= $("#txtName").val();
	var slcStatus 	= $("#slcStatus").val();

	if(txtName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Provide product name");
		$("#txtName").addClass("highlight");
		return false;
	} else { clearErrors(); }



	$("label.process").css("display", "inline");
	$("#btnUpdate").attr("disabled", true);
	$("#btnUpdate").html("Wait...");

	$.post("./includes/supply.php?action=updateExist&dest=editSupplyProduct", { supItemID:supItemID, txtName:txtName, slcStatus:slcStatus }, function(data) {
		$("label.process").css("display", "none");
		if(data=="updated") {
			swal({
				title: "Success!",
				text: "You updated product details successfully",
				icon: "success",
						timer: 1500,
						button: false
				})
					.then(value=> {
					window.location = "./workplace.php?role="+myRole+"&task=supply&subtask=supplyItems";
				}
			);
		} else {
			swal("Oops!", data, "error");
		}
		$("#btnUpdate").attr("disabled", false);
		$("#btnUpdate").html("Update");
	});
	return false;
}
function smpfyAddSupplyPrchse() {
	$("#checkBlnce, #switchBalance").click(function(){
		$('div#switchBalance').toggleClass("switchOn");
		if (document.getElementById("beginBalance").checked == true) {
			document.getElementById("beginBalance").checked = false;
		} else {
			document.getElementById("beginBalance").checked = true;
		}
		$("#vendorID, #txtVendorName").val('');
		$("div.displayInfo.vendor").css("display", "none");
		$("div.suggest.one").css("display", "none");
	});

	//
	var yearago = Number(year)-1;
	var picker = new Pikaday({
		field: document.getElementById("transDate"),
		firstDay: 6,
		maxDate: new Date(today),
		yearRange: [yearago,year],
	});

		$("#txtVendorName").keyup(function(){
		$("div.suggest").css("display", "none");
		$('div#switchBalance').removeClass("switchOn");
		var vendorName = $("#txtVendorName").val();
		if(vendorName!="") {
			$("div.suggest.vendor").css("display", "table-row");
			$.post("./includes/supply.php?action=searchRec&dest=pickVendor", { vendorName:vendorName }, function(data){
				$("div.suggest").html(data);
			});
		} else { $("div.suggest").css("display", "none"); }
		clearErrors();
	});
	//

	$("#txtItemName").keyup(function(){
	$("div.suggest").css("display", "none");
		var itemName = $("#txtItemName").val();
		if(itemName!="") {
			$("div.suggest.supply").css("display", "table-row");
			$.post("./includes/supply.php?action=searchRec&dest=pickSupplyProduct", { itemName:itemName }, function(data){
				$("div.suggest.supply").html(data);
			});
		} else { $("div.suggest.product").css("display", "none"); }
		clearErrors();
	});
	//
	$("#txtPrdQnty").on("keyup change", function() {
		var prdQnty		= $("#txtPrdQnty").val();
		var slcPrdcts	= $("#txtPrdctID").val();
		var slcMeasure	= $("#slcMeasure").val();
		if(prdQnty.match(numExp) || prdQnty!="") {
			if(slcPrdcts!="" && slcMeasure!="") {
				$.post("./includes/supply.php?action=searchRec&dest=getMsrQnty", { prdID:slcPrdcts, msrID:slcMeasure }, function(data){
					var msrQty	= data;
					var quantity = (msrQty*prdQnty);
					$("input#txtQuantity").val(quantity);
					//
					var costPrice	= $("#txtCost").val();
					var salesPrice	= $("#txtSales").val();
					if(quantity!="") {
						if(costPrice != "" || costPrice > 0 ) {
							var totalCost = Number(quantity*costPrice);
							$("#txtTtlCost").val(totalCost);
						}
					} else {
						$("#txtTtlCost").val('');
					}
				});
			}
		}
		clearErrors();
	});
	//
	$("#slcMeasure").on("change", function(e) {
		var prdQnty		= $("#txtPrdQnty").val();
		var slcPrdcts	= $("#txtPrdctID").val();
		var slcMeasure	= $("#slcMeasure").val();
		$("#txtCost, #txtTtlCost, #txtSales, #txtTtlSls").val('');
		if(prdQnty.match(numExp) || prdQnty!="") {
			if(slcPrdcts.length > 0 && slcMeasure.length > 0) {
				$.post("./includes/supply.php?action=searchRec&dest=getMsrQnty", { prdID:slcPrdcts, msrID:slcMeasure }, function(data){
					var msrQty	= data;
					var quantity = (msrQty*prdQnty);
					$("input#txtQuantity").val(quantity);
				});
			}
		}
	});
	//
	$("#txtCost").on("keyup change", function(e) {
		var quantity = $("#txtQuantity").val();
		var costPrice = $("#txtCost").val();
		if(costPrice != "" || costPrice > 0 ) {
			var totalCost = Number(quantity*costPrice);
			$("#txtTtlCost").val(totalCost);
		} else {
			$("#txtTtlCost").val('');
		}
		clearErrors();
	});

	//
	$("#txtRemarks").on("keyup change", function(e) {
		return tweetFeed(this, 500);
	});
}

function smpfyAddSupplyUsage() {
	var yearago = Number(year)-1;
	var picker = new Pikaday({
		field: document.getElementById("transDate"),
		firstDay: 6,
		maxDate: new Date(today),
		yearRange: [yearago,year],
	});

	//
	$("#checkRest, #switchRestuarant").click(function(){
		$('div#switchRestuarant').toggleClass("switchOn res");
		if (document.getElementById("restSupply").checked == true) {
			document.getElementById("restSupply").checked = false;
		} else {
			document.getElementById("restSupply").checked = true;
		}
	});

	$("#txtItemName4Usage").keyup(function(){
	$("div.suggest").css("display", "none");
		var prdctName = $("#txtItemName4Usage").val();
		if(prdctName!="") {
			$("div.suggest.supply").css("display", "table-row");
			$.post("./includes/supply.php?action=searchRec&dest=pickSupplyProduct4Usage", { prdctName:prdctName }, function(data){
				$("div.suggest.supply").html(data);
			});
		} else { $("div.suggest.product").css("display", "none"); }
		clearErrors();
	});
	//

	$("#txtPrdQnty").on("keyup change", function(e) {
		var prdQnty			= $("#txtPrdQnty").val();
		var slcPrdcts		= $("#txtPrdctID").val();
		var slcMeasure		= $("#slcMeasure").val();
		var txtCostPrice	= $("#txtCostPrice").val();
		var balance			= $("#balance").val();
		if(prdQnty.match(numExp) || prdQnty!="") {
			if(slcPrdcts!="" && slcMeasure!="") {
				$.post("./includes/supply.php?action=searchRec&dest=getMsrQnty", { prdID:slcPrdcts, msrID:slcMeasure }, function(data){
					var msrQty	= data;
					var quantity = (msrQty*prdQnty);
					if(quantity>balance) {
						$("#slcMeasure").val($("#slcMeasure option:first").val());
						$("#txtPrdQnty").val(balance);
						$("input#txtQuantity").val(balance);
						$("#txtCost").val(txtCostPrice);
						quantity=balance;
					var costPrice	= $("#txtCost").val();
					var totalCost = Number(quantity*costPrice);
					$("#txtTtlCost").val(totalCost);

					} else {
					$("input#txtQuantity").val(quantity);
					//
					$("#txtCost").val(txtCostPrice);
					var costPrice	= $("#txtCost").val();
					//var salesPrice	= $("#txtSales").val();
					if(quantity!="") {
						if(costPrice != "" || costPrice > 0 ) {
							var totalCost = Number(quantity*costPrice);
							$("#txtTtlCost").val(totalCost);
						}
						/*if(salesPrice != "" || salesPrice > 0 ) {
							var totalSales = Number(quantity*salesPrice);
							$("#txtTtlSls").val(totalSales);
						}*/
					} else {
						$("#txtTtlCost").val('');
					}
				}
				});
			}
		}
		clearErrors();
	});
	//
	$("#slcMeasure").on("change", function(e) {
		$("#txtCost, #txtTtlCost ,#txtPrdQnty,input#txtQuantity").val('');
		var prdQnty		= $("#txtPrdQnty").val();
		var slcPrdcts	= $("#txtPrdctID").val();
		var slcMeasure	= $("#slcMeasure").val();


		if(prdQnty.match(numExp) || prdQnty!="") {
			if(slcPrdcts.length > 0 && slcMeasure.length > 0) {
				$.post("./includes/supply.php?action=searchRec&dest=getMsrQnty", { prdID:slcPrdcts, msrID:slcMeasure }, function(data){
					var msrQty	= data;
					var quantity = (msrQty*prdQnty);
					$("input#txtQuantity").val(quantity);
				});
			}
		}
	});
	//
	$("#txtCost").on("keyup change", function(e) {
		var quantity = $("#txtQuantity").val();
		var costPrice = $("#txtCost").val();
		if(costPrice != "" || costPrice > 0 ) {
			var totalCost = Number(quantity*costPrice);
			$("#txtTtlCost").val(totalCost);
		} else {
			$("#txtTtlCost").val('');
		}
		clearErrors();
	});

	//
	$("#txtRemarks").on("keyup change", function(e) {
		return tweetFeed(this, 500);
	});
}
function check_addsupplyPrchse() {
	var beginBalance	= $("input#beginBalance:checked").val();
	if(beginBalance!="on") { var beginBalance="no"; } else { var beginBalance="yes"; }
	var vendorName	= $("#txtVendorName").val();
	var vendorID	= $("#vendorID").val();
	var listItem	= $("div.theForm .listItem").height();

	if(beginBalance=="no") {
		if(vendorID.length < 1 || vendorName.length < 1) {
			$("#error1").css("display", "inline");
			$("#error1").html("Please select vendor");
			$("#txtVendorName").addClass("highlight");
			$("div.suggest").css("display", "none");
			return false;
		} else { clearErrors(); }
	}

	if(listItem<1) {
		$("#error3").css("display", "inline");
		$("#error3").html("You must add at least one item to the list");
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	return true;
}
function check_addsupplyUsage() {
	var listItem	= $("div.theForm .listItem").height();

	if(listItem<1) {
		$("#error3").css("display", "inline");
		$("#error3").html("You must add at least one product to the list");
		if(window.innerWidth<=768) { $('html, body').animate({ scrollTop: $(".record.four").offset().top }, 'slow'); }
		return false;
	} else { clearErrors(); }

	$("label.process").css("display", "inline");
	$("#btnSave").attr("disabled", true);
	$("#btnSave").html("Wait...");

	return true;
}
function add2List4PrchseSupply() {// ok
	var txtPrdctID = $("#txtPrdctID").val();	var txtItemName = $("#txtItemName").val();
	var txtPrdQnty = $("#txtPrdQnty").val();	var quantity = $("#txtQuantity").val();
	var slcMeasure = $("#slcMeasure").val();	var slcMeasure2 = $("#slcMeasure :selected").text();
	var txtCost = $("#txtCost").val();

	var ttlCost = Number(quantity*txtCost);

	if(txtItemName.length < 1 || txtPrdctID=="") {
		$("#error2").css("display", "inline");
		$("#error2").html("Select product");
		$("#txtItemName").addClass("highlight");
		return false;
	} else { clearErrors(); }

	if(txtPrdQnty.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity is missing");
		$("#txtPrdQnty").addClass("highlight");
		return false;
	} else if(Number(txtPrdQnty) < 0.1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity must be greater than 0");
		$("#txtPrdQnty").addClass("highlight");
		return false;
	} else { clearErrors(); }

	if(txtCost.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Cost price is missing");
		$("#txtCost").addClass("highlight");
		return false;
	} else if(Number(txtCost) < 0.0001) {
		$("#error2").css("display", "inline");
		$("#error2").html("Cost price must be greater than 0");
		$("#txtCost").addClass("highlight");
		return false;
	} else { clearErrors(); }

	var productID	= txtPrdctID.trim();
	var prdAdded	= $("input#prdID", list);
	var msrAdded	= $("input#msrID", list);

	if((!prdAdded.is("*") || !prdAdded.filter(function(i, el){return el.value.indexOf(productID) > -1}).is("*"))) {
		$("div.list").append('<div class="listItem num'+num+'">\
			<div class="cave serial">\
				<input type="hidden" id="prdID" name="prdID[]" value="'+txtPrdctID+'" readonly="readonly" /></div>\
			<div class="cave medium">\
				<input type="text" value="'+txtItemName+'" readonly="readonly" /></div>\
			<div class="cave small">\
				<input type="text" name="quantity[]" value="'+txtPrdQnty+'" readonly="readonly" /></div>\
			<div class="cave tiny">\
				<input type="hidden" id="msrID" name="msrID[]" value="'+slcMeasure+'" readonly="readonly" />\
				<input type="text" value="'+slcMeasure2+'" readonly="readonly" />\
			</div>\
			<div class="cave small">\
				<input type="text" name="costPrice[]" value="$'+txtCost+'" readonly="readonly" /></div>\
			<div class="cave small subTtl"><input type="text" value="$'+ttlCost+'" readonly="readonly" /></div>\
			<div class="cave small"><a id="remove" onclick="return removeItem('+num+');">remove</a></div>\
		</div>');
		$("#slcMeasure").html('');
		$("#txtPrdctID,#txtItemName, #txtPrdQnty, #txtQuantity, #txtCost, #txtTtlCost").val('');
		$("div.displayInfo.product").css("display", "none");
		num++;

    } else {
        swal("Oops", txtPrdctName + " has already been added to list", "error");
    }
	return false;
}
function add2List4SupplyUsage() { // ok

	var txtPrdctID = $("#txtPrdctID").val();	var txtPrdctName = $("#txtItemName4Usage").val();
	var txtPrdQnty = $("#txtPrdQnty").val();	var quantity = $("#txtQuantity").val();
	var slcMeasure = $("#slcMeasure").val();	var slcMeasure2 = $("#slcMeasure :selected").text();
	var txtCost = $("#txtCost").val();
	var ttlCost = Number(quantity*txtCost);

	if(txtPrdctName.length < 1 || txtPrdctID=="") {
		$("#error2").css("display", "inline");
		$("#error2").html("Select product");
		$("#txtItemName4Usage").addClass("highlight");
		return false;
	} else { clearErrors(); }

	if(txtPrdQnty.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity is missing");
		$("#txtPrdQnty").addClass("highlight");
		return false;
	} else if(Number(txtPrdQnty) < 0.1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity must be greater than 0");
		$("#txtPrdQnty").addClass("highlight");
		return false;
	} else { clearErrors(); }



	var productID	= txtPrdctID.trim();
	var prdAdded	= $("input#prdID", list);
	var msrAdded	= $("input#msrID", list);

	if((!prdAdded.is("*") || !prdAdded.filter(function(i, el){return el.value.indexOf(productID) > -1}).is("*"))) {
		$("div.list").append('<div class="listItem num'+num+'">\
			<div class="cave serial">\
				<input type="hidden" id="prdID" name="prdID[]" value="'+txtPrdctID+'" readonly="readonly" /></div>\
			<div class="cave medium">\
				<input type="text" value="'+txtPrdctName+'" readonly="readonly" /></div>\
			<div class="cave small">\
				<input type="text" name="quantity[]" value="'+txtPrdQnty+'" readonly="readonly" /></div>\
			<div class="cave tiny">\
				<input type="hidden" id="msrID" name="msrID[]" value="'+slcMeasure+'" readonly="readonly" />\
				<input type="text" value="'+slcMeasure2+'" readonly="readonly" />\
			</div>\
			<div class="cave small">\
				<input type="text" name="costPrice[]" value="$'+txtCost+'" readonly="readonly" /></div>\
			<div class="cave small subTtl"><input type="text" value="$'+ttlCost+'" readonly="readonly" /></div>\
			<div class="cave small"><a id="remove" onclick="return removeItem('+num+');">remove</a></div>\
		</div>');
		$("#slcMeasure").html('');
		$("#txtPrdctID,#txtItemName4Usage, #txtPrdQnty, #txtQuantity, #txtCost, #txtTtlCost").val('');
		$("div.displayInfo.product").css("display", "none");
		num++;

    } else {
        swal("Oops", txtPrdctName + " has already been added to list", "error");
    }
	return false;
}
//
function editSupplyUseSt(usageID) {
	//
	swal({
		title: "Are you sure to change?",
		text: "You going to chnage this supply usage for restaurant use status!",
		icon: "warning",
		dangerMode:true,
		buttons: ["Cancel","Yes, update it!"]
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/supply.php?action=updateExist&dest=editSupplyUseSt",{usageID:usageID },function(data){
				if(data=="updated") {
					swal({
						title: "Success!",
						text: "Your changes has been saved.",
						icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
						location.reload();
					});
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
}
//
function simplyAddSupplyItems(){
	$("#checkUnit, #switchUnit").click(function(){
		$('div#switchUnit').toggleClass("switchOn");
		if (document.getElementById("isDefualt").checked == true) {
			document.getElementById("isDefualt").checked = false;
		} else {
			document.getElementById("isDefualt").checked = true;
		}
	});
	//
	$("#slcUnits").change(function(){
		var slcUnits = $("#slcUnits").val();
		if(slcUnits!="all") {
			$.post("./includes/supply.php?action=searchRec&dest=pickProMsure",{ slcUnits:slcUnits }, function(data) {
				$("#slcMsrmnt").html(data);
			});
		} else { $("#slcMsrmnt").html('<option value=""></option>'); }
		clearErrors();
	});
}

function addMsure4Supply() {
	var slcUnits = $("#slcUnits").val();
	var slcMsrmnt = $("#slcMsrmnt").val(); 		var slcMsrmnt2 = $("#slcMsrmnt :selected").text();
	var isDefualt	= $("input#isDefualt:checked").val();
	if(isDefualt!="on") { var isDefualt="No"; } else { var isDefualt="Yes"; }

	if(slcUnits.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Select unit type");
		$("#slcUnits").addClass("highlight");
		return false;
	} else { clearErrors(); }
	if(slcMsrmnt.length < 1) {
		$("#error4").css("display", "inline");
		$("#error4").html("Select measurement");
		$("#slcMsrmnt").addClass("highlight");
		return false;
	} else { clearErrors(); }

	var newValue 	= "Yes";
	var check		= $("input#newValue", list);
	var MsrmntID	= slcMsrmnt.trim();
	var msrAdded	= $("input#msureID", list);


	if((!check.is("*") || !check.filter(function(i, el){return el.value.indexOf(isDefualt) > -1}).is("*")) && (!msrAdded.is("*") || !msrAdded.filter(function(i, el){return el.value.indexOf(MsrmntID) > -1}).is("*")) ) {
		$("div.list").append('<div class="listItem num'+num+'">\
			<div class="cave serial">\
			<input type="hidden" id="msureID" name="msureID[]" value="'+slcMsrmnt+'" readonly="readonly" />\
			<input type="hidden" name="newValue[]" id="newValue" value="'+newValue+'" readonly="readonly" /></div>\
			<div class="cave medium"><input type="text" value="'+slcMsrmnt2+'" readonly="readonly" /></div>\
			<div class="cave medium"><input type="text" name="isDefualt[]" value="'+isDefualt+'" readonly="readonly" /></div>\
			<div class="cave small"><a id="remove" onclick="return removeItem('+num+');">remove</a></div>\
		</div>');
		$("#slcUnits option:first").attr("selected", "selected");
		$("#slcMsrmnt").html("");
		$("input#isDefualt").prop("checked", false);
		$("div.switch").removeClass("switchOn");
		num++;
	} else {
        swal("Oops","This measurement already been added to list", "error");
    }

	return false;
}
function check_addSupplyItem() {
	var txtName		= $("#txtName").val();
	var listItem	= $("div.theForm .listItem").height();
	if(txtName.length < 1) {
		$("#error1").css("display", "inline");
		$("#error1").html("Provide item name");
		$("#txtName").addClass("highlight");
		if(window.innerWidth<=768) { $('html, body').animate({ scrollTop: $(".record.one").offset().top }, 'slow'); }
		return false;
	} else { clearErrors(); }
		if(listItem<1) {
		$("#error2").css("display", "inline");
		$("#error2").html("You must assign at least one measurement to the item");
		return false;
	} else { clearErrors(); }
}
function addSupplyProduct() {
		swal({
		title: "Add Product",
		text: 'Give a name to this product',
		content: "input",
		buttons:["Cancel","Save"]
	})
	.then(product=> {
		if (product) {
			$.post("./includes/supply.php?action=saveNew&dest=addSupplyProduct&addedBy="+myUser, { product:product }, function(data){
				var addedpos = data.search("added");
				if(addedpos==0) {
					var lastID = data.slice(6,21);
					$("#txtPrdctName").val(product);
					$("#txtPrdctID").val(lastID);
					swal({
						title: "Success!",
						text: "You successfully added new category.",
						icon: "success",
						timer: 1500,
						button: false
					});
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
	return false;

}
//
function addNewItem4PrchseSupply() {
	var suppID	= $("#suppID").val();
	var beginblnce	= $("#beginblnce").val();
	var txtPrdctID	= $("#txtPrdctID").val();       var txtPrdctName	= $("#txtItemName").val();
	var slcMeasure	= $("#slcMeasure").val();		var slcMeasure2	= $("#slcMeasure :selected").text();
	var txtPrdQnty	= $("#txtPrdQnty").val();
	var txtCost		= $("#txtCost").val();
	var myWhouse	= $("#myWhouse").val();


	if(txtPrdctID.length < 1 || txtItemName.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select product");
		$("#txtItemName").addClass("highlight");
		return false;
	} else { clearErrors(); }

	if(txtPrdQnty.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity is missing");
		$("#txtPrdQnty").addClass("highlight");
		return false;
	} else if(Number(txtPrdQnty) < 0.01) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity must be greater than 0");
		$("#txtPrdQnty").addClass("highlight");
		return false;
	} else { clearErrors(); }

	if(txtCost.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Cost price is missing");
		$("#txtCost").addClass("highlight");
		return false;
	} else if(Number(txtCost) < 0.0001) {
		$("#error2").css("display", "inline");
		$("#error2").html("Cost price must be greater than 0");
		$("#txtCost").addClass("highlight");
		return false;
	} else { clearErrors(); }


	$("#add2list4SuplyPrchse").html("Wait...");
	$("#add2list4SuplyPrchse").removeAttr("onclick");

	$.post("./includes/supply.php?action=saveNew&dest=addNewItem4PrchseSupply", {suppID:suppID, beginblnce:beginblnce, prdtID:txtPrdctID, quantity:txtPrdQnty, measure:slcMeasure, costPrice:txtCost }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new item for this purchase supply record.",
				icon: "success",
				timer: 1500,
				button: false
			})
				.then(value=> {
					location.reload();
				}
			);
		} else {
			swal("Oops!", data, "error");
				$("#add2list4SuplyPrchse").html("Add to List");
				$("#add2list4SuplyPrchse").attr("onclick","return addNewItem4PrchseSupply();");
		}
	});
	return false;
}//
function addNewItem4SupplyUsage() {
	var usageID	= $("#usageID").val();
	var txtPrdctID	= $("#txtPrdctID").val();       var txtPrdctName	= $("#txtItemName4Usage").val();
	var slcMeasure	= $("#slcMeasure").val();		var slcMeasure2	= $("#slcMeasure :selected").text();
	var txtPrdQnty	= $("#txtPrdQnty").val();
	var txtCost		= $("#txtCost").val();
	var myWhouse	= $("#myWhouse").val();


	if(txtPrdctID.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Select product");
		$("#txtPrdctID").addClass("highlight");
		return false;
	} else { clearErrors(); }

	if(txtPrdQnty.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity is missing");
		$("#txtPrdQnty").addClass("highlight");
		return false;
	} else if(Number(txtPrdQnty) < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Quantity must be greater than 0");
		$("#txtPrdQnty").addClass("highlight");
		return false;
	} else { clearErrors(); }

	if(txtCost.length < 1) {
		$("#error2").css("display", "inline");
		$("#error2").html("Cost price is missing");
		$("#txtCost").addClass("highlight");
		return false;
	} else if(Number(txtCost) < 0.0001) {
		$("#error2").css("display", "inline");
		$("#error2").html("Cost price must be greater than 0");
		$("#txtCost").addClass("highlight");
		return false;
	} else { clearErrors(); }


	$("#add2list4SuplyUsage").html("Wait...");
	$("#add2list4SuplyUsage").removeAttr("onclick");

	$.post("./includes/supply.php?action=saveNew&dest=addNewItem4SupplyUsage", { usageID:usageID, prdtID:txtPrdctID, quantity:txtPrdQnty, measure:slcMeasure, costPrice:txtCost }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new item for this supply usage record.",
				icon: "success",
				timer: 1500,
				button: false
			})
				.then(value=> {
					location.reload();
				}
			);
		} else {
			swal("Oops!", data, "error");
				$("#add2list4SuplyUsage").html("Add to List");
				$("#add2list4SuplyUsage").attr("onclick","return addNewItem4SupplyUsage();");
		}
	});
	return false;
}
//

function delSupplyPrchseItem(recNum, recID, suppID) {
	swal({
		title: "Are you sure to delete?",
		text: "You going to remove this item from this purchase supply!",
		icon: "warning",
		dangerMode:true,
		buttons:["Cancel","'Yes, remove it!"],
		closeOnConfirm: false
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/supply.php?action=deleteRec&dest=delSupplyPrchseItem",{ recID:recID, suppID:suppID }, function(data){
				if(data=="deleted") {
					swal({
						title: "Success",
						text: "item you selected has been removed permenantly",
						icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
						location.reload();
					});
				} else if(data=="clear-purchase") {
					swal({
						title: "Success",
						text: "item you selected has been removed permenantly",
						icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
						window.location = "./workplace.php?role="+myRole+"&task=supply&subtask=supplyPrchse";
					});
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
	return false;
}
function delSupplyUsageItem(recNum, recID, usageID) {
	swal({
		title: "Are you sure to delete?",
		text: "You going to remove this item from this list!",
		icon: "warning",
		dangerMode:true,
		buttons:["Cancel","'Yes, remove it!"],
		closeOnConfirm: false
	})
	.then(willDelete=> {
		if(willDelete) {
			$.post("./includes/supply.php?action=deleteRec&dest=delSupplyUsageItem",{ recID:recID, usageID:usageID }, function(data){
				if(data=="deleted") {
					swal({
						title: "Success",
						text: "item you selected has been removed permenantly",
						icon: "success",
						timer: 1500,
						button: false
					})
					.then(value=> {
						location.reload();
					});
				} else {
					swal("Oops!", data, "error");
				}
			});
		}
	});
	return false;
}

function catchPrdct4Supply(supItemID,supItemName,measures,defaultMsr,quantity) {
	//alert(supItemName);
	$("#txtItemName").val(supItemName);
	$("#pVName4prdct").html(supItemName);
	$("#txtPrdctID").val(supItemID);
	$("#pQuantity").val(quantity);
	$("#prdQnty").attr(quantity);
	$("#slcMeasure").html(measures);
	$("div.suggest.supply").css("display", "none");
	$("p#pQuantity").html(quantity+' '+defaultMsr);
	$("div.displayInfo.product").css("display", "inline");
}
//
function catchPrdct4SupplyUsage(supItemID,supItemName,measures,defaultMsr,quantity,costPrice) {
	$("#txtItemName4Usage").val(supItemName);
	$("#pVName4prdct").html(supItemName);
	$("#txtPrdctID").val(supItemID);
	$("#pQuantity").val(quantity);
	$("#balance").val(quantity);
	$("#txtCostPrice").val(costPrice);
	$("#txtPrdQnty").attr('placeholder',quantity);
	$("#slcMeasure").html(measures);
	$("div.suggest.supply").css("display", "none");
	$("p#pQuantity").html(quantity+' '+defaultMsr);
	$("div.displayInfo.product").css("display", "inline");

}

function catchVndr4PchsSupply(vndID,fullname,phone,balance) {
	$("input#vendorID").val(vndID);
	$("input#txtVendorName").val(fullname);
	$("div.displayInfo.vendor").css("display", "inline");
	$("p#pVName").html(fullname);
	$("p#pVPhone").html(phone);
	if(balance>0) {
		$("p#pVBalance").html('$'+balance);
	} else {
		$("p#pVBalance").html(balance);
	}
	$("div.suggest").css("display", "none");
}
function catchSupplyItem(recID) {
	$.post("./includes/supply.php?action=get_recInfo&dest=getSupplyItem", { recID:recID}, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function catchPurchaseSupply(recID) {
	$.post("./includes/supply.php?action=get_recInfo&dest=getPrchaseSupply", { recID:recID}, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function catchSupplyUsage(recID) {
	$.post("./includes/supply.php?action=get_recInfo&dest=getSupplyUsage", { recID:recID }, function(data) {
		$("div#foundNum").html('<label id="count">1</label> record has been selected.<span id="refresh"></span>');
		$("div#dataTable").html(data);
	});
	$("div.suggest").css("display", "none");
}
function check_addLocalVendor4Pop() {
	var txtVName 	= $("#txtVName4Local").val();
	var txtVPhone	= $("#txtVPhone4Local").val();
	var txtVEmail 	= $("#txtVEmail4Local").val();

	if(txtVName.length < 1) {
		$("#poplocalerror1").css("display", "inline");
		$("#poplocalerror1").html("Provide vendor's full name");
		$("#txtVName4Local").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(txtVPhone.length < 1) {
		$("#poplocalerror2").css("display", "inline");
		$("#poplocalerror2").html("Phone number is missing");
		$("#txtVPhone4Local").css("border-color", "#FF0000");
		return false;
	} else { clearErrors(); }

	if(txtVEmail.length > 0) {
		var emailExp = /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/;
		if(!txtVEmail.match(emailExp)) {
			$("#poplocalerror3").css("display", "inline");
			$("#poplocalerror3").html("invalid email address");
			$("#txtVEmail4Local").css("border-color", "#FF0000");
			return false;
		} else { clearErrors(); }
	}

	$(".btnAdd").attr("disabled", true);
	$(".btnAdd").html("Wait...");

	$.post("./includes/supply.php?action=saveNew&dest=addLocalVendor", { txtName:txtVName, txtPhone:txtVPhone, txtEmail:txtVEmail }, function(data) {
		var addedpos = data.search("added");
		$("label.process").css("display", "none");
		if(addedpos==0) {
			var lastID = data.slice(6,21);
			swal({
				title: "Success!",
				text: "You added new vendor successfully.",
				icon: "success",
				timer: 1500,
				button: false,
			});
			$("#txtVName, #txtVPhone, #txtVEmail").val('');
			$("input#vendorID").val(lastID);
			$("input#txtVendorName").val(txtVName);
			$("div.displayInfo.vendor").css("display", "inline");
			$("p#pVName").html(txtVName);
			$("p#pVPhone").html(txtVPhone);
			$("p#pVBalance").html(0);
			$("div.suggest.vendor").css("display", "none");
			 $('input#addLocalVendorForm').prop('checked', false);

		} else {
			swal("Oops!", data, "error");
		}
		$("#btnAdd").attr("disabled", false);
		$("#btnAdd").html("Add");
	});
	return false;
}