(function ($) {
  Date.DEFAULT_LOCALE = "en-US";
  Date.UNITS = { year: 24 * 60 * 60 * 1e3 * 365, month: (24 * 60 * 60 * 1e3 * 365) / 12, week: 24 * 60 * 60 * 1e3 * 7, day: 24 * 60 * 60 * 1e3, hour: 60 * 60 * 1e3, minute: 60 * 1e3, second: 1e3 };
  Date.setLocale = function (locale) {
    Date.DEFAULT_LOCALE = locale ? locale : Date.DEFAULT_LOCALE;
  };
  Date.getUnits = function () {
    return Date.UNITS;
  };
  Date.getDayNames = function (abbreviation = false) {
    const formatter = new Intl.DateTimeFormat(Date.DEFAULT_LOCALE, { weekday: abbreviation ? "short" : "long", timeZone: "UTC" });
    const days = [2, 3, 4, 5, 6, 7, 8].map((day) => {
      const dd = day < 10 ? `0${day}` : day;
      return new Date(`2017-01-${dd}T00:00:00+00:00`);
    });
    return days.map((date) => formatter.format(date));
  };
  Date.getMonthNames = function (abbreviation = false) {
    const formatter = new Intl.DateTimeFormat(Date.DEFAULT_LOCALE, { month: abbreviation ? "short" : "long", timeZone: "UTC" });
    const months = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12].map((month) => {
      const mm = month < 10 ? `0${month}` : month;
      return new Date(`2017-${mm}-01T00:00:00+00:00`);
    });
    return months.map((date) => formatter.format(date));
  };
  Date.prototype.showDateFormatted = function () {
    let options = { weekday: "long", year: "numeric", month: "short", day: "numeric" };
    return this.toLocaleDateString(Date.DEFAULT_LOCALE, options);
  };
  Date.prototype.copy = function () {
    return this.clone();
  };
  Date.prototype.getMonthName = function (abbreviation = false) {
    const formatter = new Intl.DateTimeFormat(Date.DEFAULT_LOCALE, { month: abbreviation ? "short" : "long", timeZone: "UTC" });
    return formatter.format(this);
  };
  Date.prototype.getDaysInMonth = function () {
    return [31, this.isLeapYear() ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][this.getMonth()];
  };
  Date.prototype.isLeapYear = function () {
    let year = this.getFullYear();
    return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
  };
  Date.prototype.getDayName = function (abbreviation = false) {
    const formatter = new Intl.DateTimeFormat(Date.DEFAULT_LOCALE, { weekday: abbreviation ? "short" : "long", timeZone: "UTC" });
    return formatter.format(this);
  };
  $.fn.extend({
    triggerAll: function (events, params = []) {
      let el = this,
        i,
        eventArray = events.split(" ");
      for (i = 0; i < eventArray.length; i += 1) {
        el.trigger(eventArray[i], params);
      }
      return el;
    },
  });
  $.bsCalendar = {
    setDefaults(o = {}) {
      this.DEFAULTS = $.extend(true, this.DEFAULTS, o || {});
    },
    setDefault(prop, value) {
      this.DEFAULTS[prop] = value;
    },
    getDefaults(container) {
      this.DEFAULTS.url = container.data("target") || container.data("bsTarget") || this.DEFAULTS.url;
      return this.DEFAULTS;
    },
    DEFAULTS: {
      locale: "en",
      url: null,
      width: "300px",
      icons: { prev: "bi bi-chevron-left", next: "bi bi-chevron-right", eventEdit: "bi bi-pen", eventRemove: "bi bi-calendar2-x" },
      showTodayHeader: true,
      showPopover: true,
      popoverConfig: { animation: false, html: true, delay: 400, placement: "top", trigger: "hover" },
      showEventEditButton: false,
      showEventRemoveButton: false,
      formatPopoverContent(events) {
        return (
          '<div class="list-group list-group-flush">' +
          events
            .map((e) => {
              return `<div class="list-group-itemp p-1">${e.title}</div>`;
            })
            .join("") +
          "</div>"
        );
      },
      formatEvent(event) {
        return drawEvent(event);
      },
      formatNoEvent(date) {
        return drawNoEvent(date);
      },
      queryParams(params) {
        return params;
      },
      onClickEditEvent(e, event) {},
      onClickDeleteEvent(e, event) {},
    },
  };
  const eventEditButton = { class: "btn btn-link p-0 .js-edit-event" };
  const eventRemoveButton = { class: "btn btn-link p-0 .js-delete-event" };
  Date.prototype.addDays = function (days) {
    let date = new Date(this.valueOf());
    date.setDate(date.getDate() + days);
    return date;
  };
  Date.prototype.subDays = function (days) {
    let date = new Date(this.valueOf());
    date.setDate(date.getDate() - days);
    return date;
  };
  Date.prototype.subMonths = function (months) {
    const month = this.getMonth();
    this.setMonth(this.getMonth() - months);
    while (this.getMonth() === month) {
      this.subDays(1);
    }
    return this;
  };
  Date.isLeapYear = function (year) {
    return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
  };
  Date.prototype.addMonths = function (months) {
    let n = this.getDate();
    this.setDate(1);
    this.setMonth(this.getMonth() + months);
    this.setDate(Math.min(n, this.getDaysInMonth()));
    return this;
  };
  Date.prototype.getFirstDayOfMonth = function () {
    return new Date(this.getFullYear(), this.getMonth(), 1);
  };
  Date.prototype.getLastDayOfMonth = function () {
    return new Date(this.getFullYear(), this.getMonth() + 1, 0);
  };
  Date.prototype.getMonday = function () {
    let d = new Date(this.valueOf());
    let day = d.getDay(),
      diff = d.getDate() - day + (day === 0 ? -6 : 1);
    return new Date(d.setDate(diff));
  };
  Date.prototype.getFirstDayOfWeek = function () {
    let d = this.copy();
    let day = d.getDay(),
      diff = d.getDate() - day + (day === 0 ? -6 : 1);
    return new Date(d.setDate(diff));
  };
  Date.prototype.getLastDayOfWeek = function () {
    let d = this.clone();
    const first = d.getDate() - d.getDay() + 1;
    const last = first + 6;
    return new Date(d.setDate(last));
  };
  Date.prototype.getSunday = function () {
    let d = new Date(this.valueOf());
    const first = d.getDate() - d.getDay() + 1;
    const last = first + 6;
    return new Date(d.setDate(last));
  };
  Date.prototype.clone = function () {
    return new Date(this.valueOf());
  };
  Date.prototype.formatDate = function (asArray) {
    let d = new Date(this.valueOf()),
      month = "" + (d.getMonth() + 1),
      day = "" + d.getDate(),
      year = d.getFullYear();
    if (month.length < 2) month = "0" + month;
    if (day.length < 2) day = "0" + day;
    return asArray ? [year, month, day] : [year, month, day].join("-");
  };
  Date.prototype.getWeek = function () {
    let d = new Date(Date.UTC(this.getFullYear(), this.getMonth(), this.getDate()));
    d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay() || 7));
    let yearStart = new Date(Date.UTC(d.getUTCFullYear(), 0, 1));
    return Math.ceil(((d - yearStart) / 864e5 + 1) / 7);
  };
  function formatDate(date) {
    let date_arr = date.split("-");
    return date_arr[2] + "." + date_arr[1] + "." + date_arr[0];
  }
  function formatTime(time) {
    return time.substring(0, 5);
  }
  function drawEvent(event) {
    let desc = event.description ? '<p class="m-0">' + event.description + "</p>" : "";
    let s, e;
    let startDate = event.start.split(" ")[0];
    let endDate = event.end.split(" ")[0];
    if (startDate === endDate) {
      s = formatTime(event.start.split(" ")[1]);
      e = formatTime(event.end.split(" ")[1]);
    } else {
      s = formatDate(startDate);
      e = formatDate(endDate);
    }
    return `
        <div class="d-flex flex-column p-3" style="font-size:.8em">
            <h6 class="mb-0 text-uppercase">${event.title}</h6>
            <small class="text-muted">${s} - ${e}</small>
            ${desc}
        </div>
        `;
  }
  function drawNoEvent(date) {
    return `
        <div class="p-2" style="font-size:.8em">
        <h6 class="mb-0 text-center">No appointments on this day</h6>
        </div>
        `;
  }
  function getFormattedDate(date) {
    return `${date.getDate()}. ${date.getMonthName()} ${date.getFullYear()}`;
  }
  function drawTemplate(container) {
    let settings = container.data("settings");
    let todayHeader = "";
    if (settings.showTodayHeader) {
      let today = new Date();
      todayHeader = `
                
            `;
    }
    container.css({ width: settings.width }).html(`
			${todayHeader}
            <div class="d-flex flex-nowrap align-items-center p-2">
                <a href="#0" class="btn btn-link text-decoration-none btn-prev-month" style="color: #FE5959"><i class="fa fa-angle-left"></i></a>
                <span class="btn btn-link text-decoration-none flex-fill btn-curr-month month-name" style="max-width: 150px; color: #FE5959"></span>
                <a href="#0" class="btn btn-link text-decoration-none btn-next-month" style="color: #FE5959"><i class="fa fa-angle-right"></i></a>
            </div>
            <div class="d-flex flex-nowrap align-items-center js-weekdays bootstrap-calendar-weekday-row justify-content-center">
                
            </div>
             <div class="js-weeks"></div>
            <div class="dates"></div>
            
        `);
    let cellWidthHeight = container.width() / 8;
    let fontSize = cellWidthHeight / 3;
    let cellCss = { color: "#adadad", lineHeight: cellWidthHeight + "px", fontSize: fontSize + "px", height: cellWidthHeight, width: cellWidthHeight };
    container.find(".js-weekdays div:first").css(cellCss);
    let currentDayName = "";
    if (container.find(".js-today").length) {
      currentDayName = new Date().getDayName(true);
    }
    Date.getDayNames(true).forEach((wd) => {
      const addClass = wd === currentDayName ? "text-warning" : "";
      $("<div>", { html: wd, class: "js-day-name-short text-center bootstrap-calendar-weekday text-center" + addClass, css: cellCss }).appendTo(container.find(".js-weekdays"));
    });
  }
  function highlightDayName(container) {
    const highlightClasses = "activeDayWeek fw-bold";
    const iSeeToday = container.find(".js-today").length !== 0;
    const wrap = container.find(".js-weekdays");
    wrap.find(".js-day-name-short").removeClass(highlightClasses);
    if (iSeeToday) {
      wrap.find(".js-day-name-short:eq(" + (container.find(".js-today").index() - 1) + ")").addClass(highlightClasses);
    }
  }
  $.fn.bsCalendar = function (options, params = null) {
    if ($(this).length > 1) {
      return $(this).each(function (i, e) {
        return $(e).bsCalendar(options, params);
      });
    }
    const CONTAINER_WRAPPER_CLASS = ".bootstrap-calendar-container";
    const container = $(this);
    let xhr = null;
    let isMethodSet = typeof options === "string";
    let settings;
    if (container.data("init") !== true) {
      settings = $.extend(true, $.bsCalendar.getDefaults(container), options || {});
      Date.setLocale(settings.locale);
      container.data("settings", $.extend(true, $.bsCalendar.getDefaults(container), options || {}));
      drawTemplate(container);
    } else {
      settings = container.data("settings");
    }
    let cellWidthHeight = container.width() / 8;
    let fontSize = cellWidthHeight / 3;
    let calendar = [];
    function isDarkMode() {
      return container.data("bsTheme") === "dark" || (container.closest("[data-bs-theme]").length && container.closest("[data-bs-theme]").data("bsTheme") === "dark");
    }
    function getEvents(container, selected, callback) {
      if (xhr) {
        xhr.abort();
        xhr = null;
      }
      if (!settings.url) {
        callback([]);
      } else {
        let data = { from: selected.clone().getFirstDayOfMonth().getFirstDayOfWeek().formatDate(false), to: selected.clone().getLastDayOfMonth().getLastDayOfWeek().formatDate(false) };
        xhr = $.ajax({
          async: true,
          url: settings.url,
          dataType: "json",
          data: settings.queryParams(data),
          success: function (events) {
            container.trigger("events-loaded", [events]);
            callback(events || []);
          },
        });
      }
    }
    function drawCalendar(containerElement, selectedDate = null) {
      if (!selectedDate) {
        selectedDate = new Date();
      }
      let activeDate = $(containerElement).find("[data-date].active").length ? $(containerElement).find("[data-date].active").data("date") : null;
      let wrap = $(containerElement).find(".js-weeks").empty();
      const startDay = selectedDate.clone().getFirstDayOfMonth().getMonday();
      const endDay = selectedDate.clone().getLastDayOfMonth().getSunday();
      let date = startDay.clone().subDays(1);
      $(containerElement)
        .find(".month-name")
        .html(selectedDate.getMonthName() + " " + selectedDate.getFullYear());
      calendar = [];
      while (date < endDay) {
        calendar.push({
          days: Array(7)
            .fill(0)
            .map(() => {
              date = date.addDays(1);
              return date;
            }),
        });
      }
      const today = new Date();
      const currentWeek = today.getWeek();
      const currentYear = today.getFullYear();
      let foundToday = false;
      calendar.forEach((week) => {
        let w = week.days[0].getWeek();
        let highlight_week = currentYear === week.days[0].getFullYear() && currentWeek === w;
        // let highlightClass = highlight_week ? "fw-bold activeDayWeek" : "fw-small";
        let weekContainer = $("<div>", { class: "d-flex flex-nowrap justify-content-center" }).appendTo(wrap);
        // $("<div>", { class: "d-flex justify-content-center align-items-center js-cal-row bootstrap-calendar-week", css: { fontSize: fontSize + "px", color: "#adadad", width: cellWidthHeight, height: cellWidthHeight }, html: ['<small class="text-center mb-0 ' + highlightClass + '">' + w + "</small>"].join("") }).appendTo(weekContainer);
        week.days.forEach((day) => {
          const isToday = today.formatDate(false) === day.formatDate(false);
          if (isToday) foundToday = true;
          const isInMonth = selectedDate.formatDate(true)[1] === day.formatDate(true)[1];
          const cellBackground = isToday ? " text-bg-primary rounded-circle " : isInMonth ? " fw-bold " : " fw-small ";
          const cellTextColor = isInMonth ? "" : "transparent";
          const highlight = !isToday ? "" : " js-today ";
          let col = $("<div>", {
            "data-date": day.formatDate(false),
            class: "position-relative d-flex justify-content-center align-items-center bootstrap-calendar-day " + highlight + cellBackground,
            css: { color: cellTextColor, cursor: "pointer", width: cellWidthHeight, height: cellWidthHeight },
            html: ['<div style="font-size:' + fontSize + 'px">' + day.formatDate(true)[2] + "</div>", ['<small class="js-count-events position-absolute text-center rounded-circle" style="width:4px; height:4px; bottom:4px; left: 50%; margin-left:-2px">', "</small>"].join("")].join(""),
          }).appendTo(weekContainer);
          col.data("events", []);
        });
      });
      highlightDayName(containerElement);
      getEvents(containerElement, selectedDate, function (events) {
        $(containerElement)
          .find("[data-date]")
          .each(function (i, e) {
            $(e).data("events", []);
          });
        events.forEach((event) => {
          const start = new Date(event.start);
          const end = new Date(event.end);
          let curDate = start.clone();
          let currDaysFormatted;
          do {
            currDaysFormatted = curDate.formatDate(false);
            let column = $(containerElement).find('[data-date="' + curDate.formatDate(false) + '"]');
            let dataEvents = [];
            if (column.length) {
              dataEvents = column.data("events");
              dataEvents.push(event);
              column.data("events", dataEvents).find(`.js-count-events`).addClass("bg-danger");
            }
            if (column.length && dataEvents.length && settings.showPopover) {
              $(column).popover("dispose");
              const popoverContent = settings.formatPopoverContent(dataEvents);
              const popoverSetup = $.extend(settings.popoverConfig || {}, { title: "<small>" + getFormattedDate(curDate) + "</small>", content: popoverContent });
              column.popover(popoverSetup);
            }
            curDate = curDate.clone().addDays(1);
          } while (currDaysFormatted < end.formatDate(false));
        });
        if (foundToday) {
          $(containerElement).find(".js-today").trigger("click");
        }
      });
    }
    function events(containerElement) {
      const settings = $(containerElement).data("settings");
      containerElement
        .on("click", ".js-event", function (e) {
          let $column = $(e.currentTarget);
          let event = $column.data("event");
          let container2 = $column.closest(CONTAINER_WRAPPER_CLASS);
          container2.trigger("click-event", [event]);
        })
        .on("click", ".btn-prev-month", function (e) {
          e.preventDefault();
          const btn = $(e.currentTarget);
          let container2 = btn.closest(CONTAINER_WRAPPER_CLASS);
          const dateBefore = container2.data("current");
          const dateAfter = dateBefore.clone().subMonths(1);
          container2.data("current", dateAfter);
          drawCalendar(container2, dateAfter);
          container2.find(".js-collapse:not(.d-none)").addClass("d-none");
          container2.triggerAll("click-prev-month change-month");
        })
        .on("click", ".btn-curr-month", function (e) {
          e.preventDefault();
          const btn = $(e.currentTarget);
          let container2 = btn.closest(CONTAINER_WRAPPER_CLASS);
          const dateAfter = new Date();
          container2.data("current", dateAfter);
          drawCalendar(container2, dateAfter);
          container2.find(".js-collapse:not(.d-none)").addClass("d-none");
          container2.triggerAll("click-current-month change-month");
        })
        .on("click", ".btn-next-month", function (e) {
          e.preventDefault();
          const btn = $(e.currentTarget);
          let container2 = btn.closest(CONTAINER_WRAPPER_CLASS);
          const dateBefore = container2.data("current");
          const dateAfter = dateBefore.clone().addMonths(1);
          container2.data("current", dateAfter);
          drawCalendar(container2, dateAfter);
          container2.find(".js-collapse:not(.d-none)").addClass("d-none");
          container2.triggerAll("click-next-month change-month");
        })
        .on("mouseleave", "[data-date]", function (e) {
          if (settings.showPopover) {
            $(e.currentTarget).popover("hide");
          }
        })
        .on("click", "[data-date]", function (e) {
          let $column = $(e.currentTarget);
          let container2 = $column.closest(CONTAINER_WRAPPER_CLASS);
          container2.find("[data-date].active").removeClass("active");
          $column.addClass("active");
          let date = new Date($column.data("date"));
          let events = $column.data("events");
          container2.find(".js-day-name").html(date.showDateFormatted());
          drawEventList(container2, events, date);
          container2.find(".js-collapse.d-none").removeClass("d-none");
          container2.trigger("change-day", [date, events]);
        });
    }
    function drawEventList(containerElement, events, date) {
      $(containerElement).trigger("show-event-list", [events]);
      let eventList = $(containerElement).find(".js-events");
      eventList.empty();
      if (!events.length) {
        $("<div>", { class: "list-group-item", html: settings.formatNoEvent(date) }).appendTo(eventList);
      } else {
        events.forEach((event) => {
          let eventHtml = settings.formatEvent(event);
          let eventWrapper = $("<div>", { class: "js-event d-flex justify-content-between align-items-center list-group-item p-0", html: `<div class="flex-fill">${eventHtml}</div><div><div class="btn-group-vertical btn-group-sm" role="group"></div></div>` }).appendTo(eventList);
          getEventButtons(containerElement, event, eventWrapper.find(".btn-group-vertical"));
          eventWrapper.data("event", event);
        });
      }
      $(containerElement).trigger("shown-event-list", [events]);
    }
    function getEventButtons(containerElement, event, wrap) {
      let settings = $(containerElement).data("settings");
      let editable = !event.hasOwnProperty("editable") || event.editable;
      let deletable = !event.hasOwnProperty("deletable") || event.deletable;
      if (settings.showEventEditButton && editable) {
        let editButton = $("<a>", { href: "#", class: eventEditButton.class, html: `<i class="${settings.icons.eventEdit}"></i>` }).appendTo(wrap);
        editButton.on("click", function (e) {
          e.preventDefault();
          settings.onClickEditEvent(e, event);
        });
      }
      if (settings.showEventRemoveButton && deletable) {
        let removeButton = $("<a>", { href: "#", class: eventRemoveButton.class, html: `<i class="${settings.icons.eventRemove}"></i>` }).appendTo(wrap);
        removeButton.on("click", function (e) {
          e.preventDefault();
          settings.onClickDeleteEvent(e, event);
        });
      }
    }
    function init() {
      if (!container.data("init")) {
        container.addClass(CONTAINER_WRAPPER_CLASS.substring(1));
        container.data("current", new Date());
        drawCalendar(container);
        events(container);
        container.data("init", true);
        container.trigger("init");
      }
      return container;
    }
    if (isMethodSet) {
      switch (options) {
        case "updateOptions": {
          const beforeOptions = container.data("settings");
          const newOptions = $.extend(true, beforeOptions, params || {});
          Date.setLocale(newOptions.locale);
          const dateAfter = container.data("current");
          container.data("settings", newOptions);
          container.empty();
          drawTemplate(container);
          drawCalendar(container, dateAfter);
          break;
        }
        case "refresh": {
          container.empty();
          const dateAfter = container.data("current");
          drawTemplate(container);
          drawCalendar(container, dateAfter);
          break;
        }
        case "setDate": {
          const dateAfter = new Date(params);
          container.data("current", dateAfter);
          drawCalendar(container, dateAfter);
          break;
        }
      }
    }
    return init();
  };
})(jQuery);
