// Show details in right panel
function showBookingDetails(date){
    const eventOnTheDay = reservationCalendarEvents?.[date];
    let html = `<div style="border-bottom: 1px solid #dfdfdf; padding: 5px 10px; font-weight: bold">Date: ${date}</div>`;
    if(eventOnTheDay){
        eventOnTheDay.forEach(event => {
            html += `<a href="${event.invoiceLink}" class="m-step-items" target="_BLANK">
                        <div class="left">
                            <p style="text-transform: uppercase; color: ${event.status === 'booked' ? '#f39c12' : '#26c323'}">${event.status}</p>
                            <span>${event.propertyName}</span>
                        </div>
                        <div class="right" style="border-color: ${event.status === 'booked' ? '#f39c12' : '#26c323'}">
                            <p>${event.clientName}</p>
                            <small>${event.timeToDisplay}</small>
                        </div>
                    </a>`;
        });
    } else {
        html += '<div style="padding: 10px">No booking/confirmation on this day</div>';
    }
    $('#calendarBookingDetails').html(html);
}

// Generate calendar events from data
function populateCalendarData() {
        $('.bootstrap-calendar-day').each(function(index, el){
            $(el).removeClass(['has-calendar-events', 'has-multiple-events']);
        });
        const propertyId = $('#room_filter').find(":selected").val();
        const currentDate = (new Date()).toISOString().split('T')[0];
        $('.bootstrap-calendar-day').each((index, item) => {
            const day = $(item).attr('data-date');
            if(day === currentDate){
                showBookingDetails(day);
                $(item).addClass('active');
            }
            var eventsOnTheDay = window?.reservationCalendarEvents?.[day];
            var shouldFontColorWhite = false;
            if(eventsOnTheDay){
                if(propertyId !== 'all'){
                    eventsOnTheDay = eventsOnTheDay.filter(function(event){
                        return event.propertyId === propertyId;
                    });
                }
                if(eventsOnTheDay.length > 0){
                    $(item).addClass('has-calendar-events');
                    if(eventsOnTheDay.length > 1){
                        $(item).addClass('has-multiple-events');
                    }
                    shouldFontColorWhite = true;
                }
            }
            if(shouldFontColorWhite){
                $(item).css('color', 'white');
            }else{
                $(item).css('color', '#666');
            }
        })
}
// Get data from backend
function getData4Calendar(month, year) {
    $('#calendar').append('<div id="calendarLoader">Loading...</div>');
    window.reservationCalendarEvents = {};

	$.ajax({
		type: "POST",
		url: "./includes/reception.php?action=get_recInfo&dest=getData4Calendar",
		data: {month, year},
		cache: false,
		success: function(result) {
            window.reservationCalendarEvents = JSON.parse(result);
            populateCalendarData();
            $('#calendar #calendarLoader').remove();
		},
	});
}
